% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{lmean}
\alias{lmean}
\title{Estimate Mean Projection Matrices}
\usage{
lmean(mats, matsout = "all")
}
\arguments{
\item{mats}{A \code{lefkoMat} object.}

\item{matsout}{A string identifying which means to estimate. Option "pop"
indicates population-level only, "patch" indicates patch-level only, and
"all" indicates that both patch- and population-level means should be
estimated.}
}
\value{
Yields a \code{lefkoMat} object with the following characteristics:

\item{A}{A list of full mean projection matrices in order of sorted
populations, patches, and years. These are typically estimated as the sums of
the associated mean \code{U} and \code{F} matrices. All matrices output in
the \code{matrix} class.}
\item{U}{A list of mean survival-transition matrices sorted as in \code{A}.
All matrices output in the \code{matrix} class.}
\item{F}{A list of mean fecundity matrices sorted as in \code{A}. All
matrices output in the \code{matrix} class.}
\item{hstages}{A data frame showing the pairing of ahistorical stages used to
create historical stage pairs. Given if the MPM is historical.}
\item{ahstages}{A data frame detailing the characteristics of associated
ahistorical stages.}
\item{labels}{A data frame detailing the order of population, patch, and year 
of each mean matrix. If \code{pop}, \code{patch}, or \code{year2} are NA in
the original \code{labels} set, then these will be re-labeled as \code{A},
\code{1}, or \code{1}, respectively.}
\item{matrixqc}{A short vector describing the number of non-zero elements in
\code{U} and \code{F} mean matrices, and the number of annual matrices.}
}
\description{
\code{lmean()} estimates mean projection matrices as element-wise arithmetic
means.
}
\examples{
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathrepm <- matrix(0, 7, 7)
lathrepm[1, 6] <- 0.345
lathrepm[2, 6] <- 0.054

lathover3 <- overwrite(stage3 = c("Sd", "Sd", "Sdl"), 
  stage2 = c("Sd", "Sd", "Sd"), stage1 = c("Sd", "rep", "rep"),
  givenrate = c(0.345, 0.345, 0.054))

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe,
  year = c(1989, 1990), stages = c("stage3", "stage2", "stage1"),
  repmatrix = lathrepm, overwrite = lathover3, yearcol = "year2",
  indivcol = "individ")

ehrlen3mean <- lmean(ehrlen3)
ehrlen3mean$A[[1]]

}
