# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Re-index Projection Matrix On Basis of Overwrite Table
#' 
#' This function takes matrix indices provided by functions \code{\link{rlefko3}()},
#' \code{\link{rlefko2}()}, \code{\link{flefko3}()}, and \code{\link{flefko2}()} and updates
#' them with information provided in the overwrite table used as input in that
#' function.
#' 
#' @param allst321 Vector containing the original element-by-element matrix index.
#' @param idx321old Vector containing the indices of matrix elements to be updated.
#' @param idx321new Vector containing the replacement matrix element indices.
#' @param convtype Vector denoting survival-transition (1) or fecundity (2).
#' @param eststag3 Vector of new stages in time \emph{t}+1.
#' @param gvnrate Vector of replacement transition values.
#' 
#' @return Vector of updated matrix indices and, where appropriate, replacement
#' matrix element values.
#' 
#' @keywords internal
#' @noRd
ovreplace <- function(allst321, idx321old, idx321new, convtype, eststag3, gvnrate) {
    .Call('_lefko3_ovreplace', PACKAGE = 'lefko3', allst321, idx321old, idx321new, convtype, eststag3, gvnrate)
}

#' Make Horizontal Data Frame Vertical
#' 
#' Function \code{pfj()} powers the R function \code{\link{verticalize3}()}, creating
#' the vertical structure and rearranging the data in that shape.
#' 
#' @param data The horizontal data file.
#' @param stageframe The stageframe object identifying the life history model
#' being operationalized.
#' @param noyears The number of years or observation periods in the dataset.
#' @param firstyear The first year or time of observation.
#' @param popidcol Column number corresponding to the identity of the population 
#' for each individual.
#' @param patchidcol Column number corresponding to the identity of the patch for
#' each individual.
#' @param individcol Column number corresponding to the identity of each 
#' individual.
#' @param blocksize The number of variables corresponding to each time step in 
#' the input dataset designated in \code{data}.
#' @param xcol Column number corresponding to the x coordinate of each individual
#' in Cartesian space.
#' @param ycol Column number corresponding to the y coordinate of each individual
#' in Cartesian space.
#' @param juvcol Column number that marks individuals in immature stages within
#' the dataset.
#' @param size1col Column number corresponding to the first or main size variable 
#' associated with the first year or observation time in the dataset.
#' @param size2col Column number corresponding to the second size variable
#' associated with the first year or observation time in the dataset.
#' @param size3col Column number corresponding to the third size variable
#' associated with the first year or observation time in the dataset.
#' @param repstr1col Column number corresponding to the main variable coding the
#' production of reproductive structures associated with the first year or 
#' observation period in the input dataset.
#' @param repstr2col Column number corresponding to a secone variable coding the
#' production of reproductive structures associated with the first year or 
#' observation period in the input dataset.
#' @param fec1col Column number corresponding to the main variable coding for
#' fecundity associated with the first year or observation period in the dataset.
#' @param fec2col Column number corresponding to a second variable coding for
#' fecundity associated with the first year or observation period in the dataset.
#' @param alive1col Column number that details whether an individual is alive at
#' a given time.
#' @param dead1col Column number that details whether an individual is dead at
#' a given time.
#' @param obs1col Column number that details whether an individual is in an
#' observable stage at a given time.
#' @param nonobs1col Column number that details whether an individual is in an
#' unobservable stage at a given time.
#' @param censorcol Column number corresponding to the first entry of a censor 
#' variable.
#' @param stagecol Column number corresponding to the first entry of a column
#' designating stages.
#' @param repstrrel This is a scalar modifier for that makes the variable in
#' \code{repstr2col} equivalent to \code{repstr1col}.
#' @param fecrel This is a scalar modifier for that makes the variable in
#' \code{fec2col} equivalent to \code{fec1col}.
#' @param NAas0 If TRUE, then all NA entries for size and fecundity variables
#' will be set to 0.
#' @param NRasRep If TRUE, then will treat non-reproductive but mature
#' individuals as reproductive during stage assignment.
#' @param stassign A logical value indicating whether to assign stages.
#' @param stszcol Column number describing which size variable to use in stage 
#' estimation.
#' @param stagenum The number of stages in the dataset.
#' @param censorkeep The value of the censoring variable identifying data
#' that should be included in analysis. Defaults to 0, but may take any value
#' including NA.
#' @param censbool A logical variable determining whether NA denotes the value
#' of the censoring variable identifying data to keep.
#' 
#' @return The output is currently a 7 element list, where each element is a
#' data frame with the same number of rows.
#' 
#' @keywords internal
#' @noRd
pfj <- function(data, stageframe, noyears, firstyear, popidcol, patchidcol, individcol, blocksize, xcol, ycol, juvcol, size1col, size2col, size3col, repstr1col, repstr2col, fec1col, fec2col, alive1col, dead1col, obs1col, nonobs1col, censorcol, stagecol, repstrrel, fecrel, NAas0, NRasRep, stassign, stszcol, stagenum, censbool) {
    .Call('_lefko3_pfj', PACKAGE = 'lefko3', data, stageframe, noyears, firstyear, popidcol, patchidcol, individcol, blocksize, xcol, ycol, juvcol, size1col, size2col, size3col, repstr1col, repstr2col, fec1col, fec2col, alive1col, dead1col, obs1col, nonobs1col, censorcol, stagecol, repstrrel, fecrel, NAas0, NRasRep, stassign, stszcol, stagenum, censbool)
}

#' Make Vertical Data Frame Historical
#' 
#' Function \code{jpf()} powers the R function \code{\link{historicalize3}()}, creating
#' the historical, vertical structure and rearranging the data in that shape.
#'
#' @param data The horizontal data file.
#' @param stageframe The stageframe object identifying the life history model
#' being operationalized.
#' @param popidcol Column number corresponding to the identity of the population 
#' for each individual.
#' @param patchidcol Column number corresponding to the identity of the patch for
#' each individual.
#' @param individcol Column number corresponding to the identity of each 
#' individual.
#' @param year2col Column number of year or time step in time \emph{t}.
#' @param year3col Column number of year or time step in time \emph{t}+1.
#' @param xcol Column number corresponding to the x coordinate of each individual
#' in Cartesian space.
#' @param ycol Column number corresponding to the y coordinate of each individual
#' in Cartesian space.
#' @param juv2col Column number coding for status as a juvenile in time \emph{t}.
#' @param juv3col Column number coding for status as a juvenile in time \emph{t}+1.
#' @param sizea2col Column number corresponding to the primary size variable in
#' time \emph{t}.
#' @param sizea3col Column number corresponding to the primary size variable in
#' time \emph{t}+1.
#' @param sizeb2col Column number corresponding to the secondary size variable in
#' time \emph{t}.
#' @param sizeb3col Column number corresponding to the secondary size variable in
#' time \emph{t}+1.
#' @param sizec2col Column number corresponding to the tertiary size variable in
#' time \emph{t}.
#' @param sizec3col Column number corresponding to the tertiary size variable in
#' time \emph{t}+1.
#' @param repstra2col Column number corresponding to the main variable coding the
#' production of reproductive structures, such as flowers, in time \emph{t}.
#' @param repstra3col Column number corresponding to the main variable coding the
#' production of reproductive structures, such as flowers, in time \emph{t}+1.
#' @param repstrb2col Column number corresponding to a second variable coding the
#' production of reproductive structures, such as flowers, in time
#' @param repstrb3col Column number corresponding to a second variable coding the
#' production of reproductive structures, such as flowers, in time \emph{t}+1.
#' @param feca2col Column number corresponding to the main variable coding for
#' fecundity in time \emph{t}.
#' @param feca3col Column number corresponding to the main variable coding for
#' fecundity in time \emph{t}+1.
#' @param fecb2col Column number corresponding to a second variable coding for
#' fecundity in time \emph{t}.
#' @param fecb3col Column number corresponding to a second variable coding for
#' fecundity in time \emph{t}+1.
#' @param alive2col Column number detailing whether an individual is alive in 
#' time \emph{t}.
#' @param alive3col Column number detailing whether an individual is alive in 
#' time \emph{t}+1.
#' @param dead2col Column number detailing whether an individual is dead in 
#' time \emph{t}.
#' @param dead3col Column number detailing whether an individual is dead in 
#' time \emph{t}+1.
#' @param obs2col Column number detailing whether an individual is in an
#' observable stage in time \emph{t}.
#' @param obs3col Column number detailing whether an individual is in an
#' unobservable stage in time \emph{t}.
#' @param nonobs2col Column number detailing whether an individual is in an
#' unobservable stage in time \emph{t}.
#' @param nonobs3col Column number detailing whether an individual is in an
#' unobservable stage in time \emph{t}+1.
#' @param repstrrel This is a scalar modifier for that makes the variable in
#' \code{repstrb2col} equivalent to \code{repstra2col}.
#' @param fecrel This is a scalar modifier for that makes the variable in
#' \code{fecb2col} equivalent to \code{feca2col}.
#' @param stage2col Column number corresponding to life history stage in time \emph{t}.
#' @param stage3col Column number corresponding to life history stage in time \emph{t}+1.
#' @param censorcol Column number corresponding to a censor variable within the 
#' dataset.
#' @param NAas0 If TRUE, then all NA entries for size and fecundity variables
#' will be set to 0.
#' @param NRasRep If TRUE, then will treat non-reproductive but mature
#' individuals as reproductive during stage assignment.
#' @param stassign A logical value indicating whether to assign stages.
#' @param stszcol Column number describing which size variable to use in stage 
#' estimation.
#' @param stagenum The number of stages in the dataset.
#' @param censbool A logical variable determining whether NA denotes the value
#' of the censoring variable identifying data to keep.
#' 
#' @return The output is currently a 7 element list, where each element is a
#' data frame with the same number of rows.
#' 
#' @keywords internal
#' @noRd
jpf <- function(data, stageframe, popidcol, patchidcol, individcol, year2col, year3col, xcol, ycol, juv2col, juv3col, sizea2col, sizea3col, sizeb2col, sizeb3col, sizec2col, sizec3col, repstra2col, repstra3col, repstrb2col, repstrb3col, feca2col, feca3col, fecb2col, fecb3col, alive2col, alive3col, dead2col, dead3col, obs2col, obs3col, nonobs2col, nonobs3col, repstrrel, fecrel, stage2col, stage3col, censorcol, NAas0, NRasRep, stassign, stszcol, stagenum, censbool) {
    .Call('_lefko3_jpf', PACKAGE = 'lefko3', data, stageframe, popidcol, patchidcol, individcol, year2col, year3col, xcol, ycol, juv2col, juv3col, sizea2col, sizea3col, sizeb2col, sizeb3col, sizec2col, sizec3col, repstra2col, repstra3col, repstrb2col, repstrb3col, feca2col, feca3col, fecb2col, fecb3col, alive2col, alive3col, dead2col, dead3col, obs2col, obs3col, nonobs2col, nonobs3col, repstrrel, fecrel, stage2col, stage3col, censorcol, NAas0, NRasRep, stassign, stszcol, stagenum, censbool)
}

#' Estimate All Elements in Function-based Population Projection Matrices
#' 
#' This function swiftly calculates matrix elements in function-based population
#' projection matrices. Used in \code{\link{flefko3}()} and \code{\link{flefko2}()}.
#' 
#' @param ppy A data frame with one row, showing the population, patch, and year.
#' @param AllStages A large data frame giving all required inputs for vital rate
#' estimation other than the vital rate model coefficients themselves. Contains
#' a row for each ultimate matrix element.
#' @param survproxy List of coefficients estimated in model of survival.
#' @param obsproxy List of coefficients estimated in model of observation.
#' @param sizeproxy List of coefficients estimated in model of size.
#' @param repstproxy List of coefficients estimated in model of reproductive 
#' status.
#' @param fecproxy List of coefficients estimated in model of fecundity.
#' @param jsurvproxy List of coefficients estimated in model of juvenile
#' survival.
#' @param jobsproxy List of coefficients estimated in model of juvenile
#' observation.
#' @param jsizeproxy List of coefficients estimated in model of juvenile size.
#' @param jrepstproxy List of coefficients estimated in model of juvenile
#' reproductive status.
#' @param survdev Scalar value to be added to the y-intercept of the linear model
#' of survival probability.
#' @param obsdev Scalar value to be added to the y-intercept of the linear model
#' of observation probability.
#' @param sizedev Scalar value to be added to the y-intercept of the linear model
#' of size transition.
#' @param repstdev Scalar value to be added to the y-intercept of the linear model
#' of reproduction probability.
#' @param fecdev Scalar value to be added to the y-intercept of the linear model
#' of fecundity.
#' @param jsurvdev Scalar value to be added to the y-intercept of the linear model
#' of juvenile survival probability.
#' @param jobsdev Scalar value to be added to the y-intercept of the linear model
#' of juvenile observation probability.
#' @param jsizedev Scalar value to be added to the y-intercept of the linear model
#' of juvenile size transition.
#' @param jrepstdev Scalar value to be added to the y-intercept of the linear model
#' of juvenile reproduction probability.
#' @param numofsizes4 Number of elements in main matrix.
#' @param matrixdim Number of rows (and columns) in the final matrix.
#' @param fecmod A scalar multiplier for fecundity.
#' @param summedvars Summed variance-covariance terms in Poisson size distribution.
#' @param sigma Standard deviation of Gaussian size distribution.
#' @param jsummedvars Summed variance-covariance terms in Poisson juvenile size
#' distribution.
#' @param jsigma Standard deviation of Gaussian juvenile size distribution.
#' @param maxsize The maximum size to be used in element estimation.
#' @param sizedist Designates whether size is Gaussian (2), Poisson (0), or
#' negative binomial (1) distributed.
#' @param fecdist Designates whether fecundity is Gaussian (2), Poisson (0), or
#' negative binomial (1) distributed.
#' @param negfec Logical value denoting whether to change negative estimated
NULL

#' Estimate All Elements in Raw Historical Matrix
#' 
#' This function swiftly calculates matrix transitions in raw historical matrices,
#' and serves as the core workhorse function behind \code{\link{rlefko3}()}.
#' 
#' @param sge9l A 7 column matrix containing information on fecundity potential,
#' reproductive status, presence in main dataset, supplied given rates (survival
#' and fecundity), and estimated proxy rates (survival and fecundity), 
#' respectively, for all combinations of stage pairs at times \emph{t}+1 and \emph{t}, 
#' and times \emph{t} and \emph{t}-1.
#' @param sge3 A 2 column matrix containing reproductive status and fecundity 
#' potential of stage pairs.
#' @param maindata A 2 column matrix of raw data denoting status as alive and
#' offspring produced.
#' @param sge93index Full matrix index vector denoting each element with respect to
#' From stage pair (times \emph{t} and \emph{t}-1) and To stage pair (times \emph{t}+1 and
#' \emph{t}).
#' @param sge92index Vector denoting From stage pair index in full matrix.
#' @param sge32index Vector indicating overall stage pair index (baseline From
#' pair for survival estimation).
#' @param sge33 Vector with stage at time \emph{t}+1 in \code{sge32index}.
#' @param sge32 Vector with stage at time \emph{t} in \code{sge32index}.
#' @param data3221 Vector of stage-pair combination indices in raw dataset.
#' @param data21 Vector of stage-pair indices in raw dataset, corresponding to
#' \code{sge32index} and used in survival estimation.
#' @param nostages The number of ahistorical stages.
#' 
#' @return Matrix composed of the survival-transitions (U) matrix as the first 
#' column and the fecundity matrix (F) as the second column.
#' 
#' @keywords internal
#' @noRd
specialpatrolgroup <- function(sge9l, sge3, maindata, sge93index, sge92index, sge32index, sge33, sge32, data3221, data21, nostages) {
    .Call('_lefko3_specialpatrolgroup', PACKAGE = 'lefko3', sge9l, sge3, maindata, sge93index, sge92index, sge32index, sge33, sge32, data3221, data21, nostages)
}

#' Estimate All Elements in Raw Ahistorical Population Projection Matrices
#' 
#' This function swiftly calculates matrix transitions in raw ahistorical matrices,
#' and serves as the core workhorse function behind \code{\link{rlefko2}()}.
#' 
#' @param sge9l A 7 column matrix containing information on fecundity potential,
#' reproductive status, presence in main dataset, supplied given rates (survival
#' and fecundity), and estimated proxy rates (survival and fecundity), 
#' respectively, for all combinations of stages at times \emph{t}+1 and \emph{t}.
#' @param sge3 A 2 column matrix containing reproductive status and fecundity 
#' potential of ahistorical stages.
#' @param maindata A 2 column matrix of raw data denoting status as alive and
#' offspring produced.
#' @param sge93index Full matrix index vector denoting each element with respect to
#' stage pairs (times \emph{t}+1 and \emph{t}).
#' @param sge92index Vector denoting From stage in full matrix.
#' @param sge32index Vector indicating overall From stage (baseline From for
#' survival estimation).
#' @param sge33 Vector with stage at time \emph{t} in \code{sge92index}.
#' @param sge32 Vector with stage at time \emph{t} in \code{sge32index}.
#' @param data3221 Vector of stage-pair indices in raw dataset.
#' @param data21 Vector of stage indices in raw dataset, corresponding to
#' \code{sge32index} and used in survival estimation.
#' @param nostages The number of ahistorical stages.
#' 
#' @return Matrix composed of the survival-transitions (U) matrix as the first 
#' column and the fecundity matrix (F) as the second column.
#' 
#' @keywords internal
#' @noRd
normalpatrolgroup <- function(sge9l, sge3, maindata, sge93index, sge92index, sge32index, sge32, data3221, data21, nostages) {
    .Call('_lefko3_normalpatrolgroup', PACKAGE = 'lefko3', sge9l, sge3, maindata, sge93index, sge92index, sge32index, sge32, data3221, data21, nostages)
}

#' Creates Index of Estimable Population Projection Matrix Elements
#' 
#' This function identifies which matrix elements in a projection matrix are
#' logically possible to estimate. In both historical and ahistorical matrices,
#' this will effectively remove the Dead stage from the final matrix output. In
#' addition, in historical matrices, this will identify matrix elements 
#' corresponding to From and To stage-pair combinations in which stages at time \emph{t}
#' are equal. Used in \code{\link{rlefko3}()}, \code{\link{rlefko2}()}, \code{\link{flefko3}()}, 
#' and \code{\link{flefko2}()}.
#' 
#' @param mainindex Should only living elements (0) be identified, or should stages
#' equal at time \emph{t} be identified (1)?
#' @param allstages A 4 column matrix identifying stage at time \emph{t}+1, stage at
#' time {t} (if historical, then in To stage-pair), stage at time \emph{t} (if
#' historical, then in From stage pair), and stage at time \emph{t}-1 if historical
#' or stage at time \emph{t} if ahistorical.
#' 
#' @return Vector of estimable matrix element indices.
#' 
#' @keywords internal
#' @noRd
hoffmannofstuttgart <- function(mainindex, allstages) {
    .Call('_lefko3_hoffmannofstuttgart', PACKAGE = 'lefko3', mainindex, allstages)
}

#' 
#' @return A list of 3 matrices, including the main MPM (A), the survival-transition
#' matrix (U), anf a fecundity matrix (F). With tweaking, can also produce a 4 column 
#' matrix showing survival probability, observation probability, reproduction
#' probability, and size transition probability, for each element of the final MPM.
#' 
#' @keywords internal
#' @noRd
jerzeibalowski <- function(ppy, AllStages, survproxy, obsproxy, sizeproxy, repstproxy, fecproxy, jsurvproxy, jobsproxy, jsizeproxy, jrepstproxy, survdev, obsdev, sizedev, repstdev, fecdev, jsurvdev, jobsdev, jsizedev, jrepstdev, numofsizes4, matrixdim, fecmod, summedvars, sigma, jsummedvars, jsigma, maxsize, sizedist, fecdist, negfec) {
    .Call('_lefko3_jerzeibalowski', PACKAGE = 'lefko3', ppy, AllStages, survproxy, obsproxy, sizeproxy, repstproxy, fecproxy, jsurvproxy, jobsproxy, jsizeproxy, jrepstproxy, survdev, obsdev, sizedev, repstdev, fecdev, jsurvdev, jobsdev, jsizedev, jrepstdev, numofsizes4, matrixdim, fecmod, summedvars, sigma, jsummedvars, jsigma, maxsize, sizedist, fecdist, negfec)
}

#' Estimates Mean Population Projection Matrix, Using Summed U and F Matrices
#' 
#' This function estimates the mean population projection matrices, treating the
#' mean as arithmetic across space but either arithmetic or geometric across time.
#' It differs from \code{\link{turbogeodiesel}()} in that it estimates the \code{A} matrix
#' as a sum of the associated \code{U} and \code{F} matrices. Used to power the
#' \code{\link{lmean}()} function.
#' 
#' @param geom Should the mean across time be geometric (1) or arithmetic (0)?
#' @param sparse Should 0s be ignored when some matrices include non-zero entries
#' in common elements?
#' @param numofpops Number of populations to be analyzed.
#' @param numofpatches Number of patches to be analyzed, where this number should
#' include a patch total across all populations.
#' @param numofyears Number of time steps to be analyzed.
#' @param loy2c Matrix denoting the population, patch, and time step designation
#' of each matrix.
#' @param Umats A matrix with all U matrices turned into columns.
#' @param Fmats A matrix with all F matrices turned into columns.
#' 
#' @return A matrix with 3n columns, where n is the sum of the number of patches and
#' populations. Each pop/patch has its own set of three columns denoting survival,
#' fecundity, and the overall sum of the previous two columns.
#' 
#' @keywords internal
#' @noRd
geodiesel <- function(geom, sparse, numofpops, numofpatches, numofyears, loy2c, Umats, Fmats) {
    .Call('_lefko3_geodiesel', PACKAGE = 'lefko3', geom, sparse, numofpops, numofpatches, numofyears, loy2c, Umats, Fmats)
}

#' Estimates Mean Population Projection Matrix
#' 
#' This function estimates the mean population projection matrices, treating the
#' mean as arithmetic across space but either arithmetic or geometric across time.
#' It differs from \code{\link{geodiesel}()} in that it estimates the \code{A} matrix
#' indepenently of the associated \code{U} and \code{F} matrices. Used to power the
#' \code{\link{lmean}()} function.
#' 
#' @param geom Should the mean across time be geometric (1) or arithmetic (0)?
#' @param sparse Should 0s be ignored when some matrices include non-zero entries
#' in common elements?
#' @param numofpops Number of populations to be analyzed.
#' @param numofpatches Number of patches to be analyzed, where this number should
#' include a patch total across all populations.
#' @param numofyears Number of time steps to be analyzed.
#' @param loy2c Matrix denoting the population, patch, and time step designation
#' of each matrix.
#' @param Umats A matrix with all U matrices turned into columns.
#' @param Fmats A matrix with all F matrices turned into columns.
#' @param Amats A matrix with all A matrices turned into columns.
#' 
#' @return A matrix with 3n columns, where n is the sum of the number of patches and
#' populations. Each pop/patch has its own set of three columns denoting survival,
#' fecundity, and the overall projection.
#' 
#' @keywords internal
#' @noRd
turbogeodiesel <- function(geom, sparse, numofpops, numofpatches, numofyears, loy2c, Umats, Fmats, Amats) {
    .Call('_lefko3_turbogeodiesel', PACKAGE = 'lefko3', geom, sparse, numofpops, numofpatches, numofyears, loy2c, Umats, Fmats, Amats)
}

