# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Re-index Projection Matrix On Basis of Overwrite Table
#' 
#' This function takes matrix indices provided by functions \code{\link{rlefko3}()},
#' \code{\link{rlefko2}()}, \code{\link{flefko3}()}, and \code{\link{flefko2}()} and updates
#' them with information provided in the overwrite table used as input in that
#' function.
#' 
#' @param allst321 Vector containing the original element-by-element matrix index.
#' @param idx321old Vector containing the indices of matrix elements to be updated.
#' @param idx321new Vector containing the replacement matrix element indices.
#' @param convtype Vector denoting survival-transition (1) or fecundity (2).
#' @param eststag3 Vector of new stages in time \emph{t}+1.
#' @param gvnrate Vector of replacement transition values.
#' 
#' @return Vector of updated matrix indices and, where appropriate, replacement
#' matrix element values.
#' 
#' @keywords internal
#' @noRd
ovreplace <- function(allst321, idx321old, idx321new, convtype, eststag3, gvnrate) {
    .Call('_lefko3_ovreplace', PACKAGE = 'lefko3', allst321, idx321old, idx321new, convtype, eststag3, gvnrate)
}

#' Estimate All Elements in Raw Historical Matrix
#' 
#' This function swiftly calculates matrix transitions in raw historical matrices,
#' and serves as the core workhorse function behind \code{\link{rlefko3}()}.
#' 
#' @param sge9l A 7 column matrix containing information on fecundity potential,
#' reproductive status, presence in main dataset, supplied given rates (survival
#' and fecundity), and estimated proxy rates (survival and fecundity), 
#' respectively, for all combinations of stage pairs at times \emph{t}+1 and \emph{t}, 
#' and times \emph{t} and \emph{t}-1.
#' @param sge3 A 2 column matrix containing reproductive status and fecundity 
#' potential of stage pairs.
#' @param maindata A 2 column matrix of raw data denoting status as alive and
#' offspring produced.
#' @param sge93index Full matrix index vector denoting each element with respect to
#' From stage pair (times \emph{t} and \emph{t}-1) and To stage pair (times \emph{t}+1 and
#' \emph{t}).
#' @param sge92index Vector denoting From stage pair index in full matrix.
#' @param sge32index Vector indicating overall stage pair index (baseline From
#' pair for survival estimation).
#' @param sge33 Vector with stage at time \emph{t}+1 in \code{sge32index}.
#' @param sge32 Vector with stage at time \emph{t} in \code{sge32index}.
#' @param data3221 Vector of stage-pair combination indices in raw dataset.
#' @param data21 Vector of stage-pair indices in raw dataset, corresponding to
#' \code{sge32index} and used in survival estimation.
#' @param nostages The number of ahistorical stages.
#' 
#' @return Matrix composed of the survival-transitions (U) matrix as the first 
#' column and the fecundity matrix (F) as the second column.
#' 
#' @keywords internal
#' @noRd
specialpatrolgroup <- function(sge9l, sge3, maindata, sge93index, sge92index, sge32index, sge33, sge32, data3221, data21, nostages) {
    .Call('_lefko3_specialpatrolgroup', PACKAGE = 'lefko3', sge9l, sge3, maindata, sge93index, sge92index, sge32index, sge33, sge32, data3221, data21, nostages)
}

#' Estimate All Elements in Raw Ahistorical Population Projection Matrices
#' 
#' This function swiftly calculates matrix transitions in raw ahistorical matrices,
#' and serves as the core workhorse function behind \code{\link{rlefko2}()}.
#' 
#' @param sge9l A 7 column matrix containing information on fecundity potential,
#' reproductive status, presence in main dataset, supplied given rates (survival
#' and fecundity), and estimated proxy rates (survival and fecundity), 
#' respectively, for all combinations of stages at times \emph{t}+1 and \emph{t}.
#' @param sge3 A 2 column matrix containing reproductive status and fecundity 
#' potential of ahistorical stages.
#' @param maindata A 2 column matrix of raw data denoting status as alive and
#' offspring produced.
#' @param sge93index Full matrix index vector denoting each element with respect to
#' stage pairs (times \emph{t}+1 and \emph{t}).
#' @param sge92index Vector denoting From stage in full matrix.
#' @param sge32index Vector indicating overall From stage (baseline From for
#' survival estimation).
#' @param sge33 Vector with stage at time \emph{t} in \code{sge92index}.
#' @param sge32 Vector with stage at time \emph{t} in \code{sge32index}.
#' @param data3221 Vector of stage-pair indices in raw dataset.
#' @param data21 Vector of stage indices in raw dataset, corresponding to
#' \code{sge32index} and used in survival estimation.
#' @param nostages The number of ahistorical stages.
#' 
#' @return Matrix composed of the survival-transitions (U) matrix as the first 
#' column and the fecundity matrix (F) as the second column.
#' 
#' @keywords internal
#' @noRd
normalpatrolgroup <- function(sge9l, sge3, maindata, sge93index, sge92index, sge32index, sge32, data3221, data21, nostages) {
    .Call('_lefko3_normalpatrolgroup', PACKAGE = 'lefko3', sge9l, sge3, maindata, sge93index, sge92index, sge32index, sge32, data3221, data21, nostages)
}

#' Creates Index of Estimable Population Projection Matrix Elements
#' 
#' This function identifies which matrix elements in a projection matrix are
#' logically possible to estimate. In both historical and ahistorical matrices,
#' this will effectively remove the Dead stage from the final matrix output. In
#' addition, in historical matrices, this will identify matrix elements 
#' corresponding to From and To stage-pair combinations in which stages at time \emph{t}
#' are equal. Used in \code{\link{rlefko3}()}, \code{\link{rlefko2}()}, \code{\link{flefko3}()}, 
#' and \code{\link{flefko2}()}.
#' 
#' @param mainindex Should only living elements (0) be identified, or should stages
#' equal at time \emph{t} be identified (1)?
#' @param allstages A 4 column matrix identifying stage at time \emph{t}+1, stage at
#' time {t} (if historical, then in To stage-pair), stage at time \emph{t} (if
#' historical, then in From stage pair), and stage at time \emph{t}-1 if historical
#' or stage at time \emph{t} if ahistorical.
#' 
#' @return Vector of estimable matrix element indices.
#' 
#' @keywords internal
#' @noRd
hoffmannofstuttgart <- function(mainindex, allstages) {
    .Call('_lefko3_hoffmannofstuttgart', PACKAGE = 'lefko3', mainindex, allstages)
}

#' Estimate All Elements in Function-based Population Projection Matrices
#' 
#' This function swiftly calculates matrix elements in function-based population
#' projection matrices. Used in \code{\link{flefko3}()} and \code{\link{flefko2}()}.
#' 
#' @param survcoefs Vector of coefficients estimated in model of survival.
#' @param obscoefs Vector of coefficients estimated in model of observation.
#' @param sizecoefs Vector of coefficients estimated in model of size.
#' @param repstcoefs Vector of coefficients estimated in model of reproductive 
#' status.
#' @param feccoefs Vector of coefficients estimated in model of fecundity.
#' @param jsurvcoefs Vector of coefficients estimated in model of juvenile
#' survival.
#' @param jobscoefs Vector of coefficients estimated in model of juvenile
#' observation.
#' @param jsizecoefs Vector of coefficients estimated in model of juvenile size.
#' @param jrepstcoefs Vector of coefficients estimated in model of juvenile
#' reproductive status.
#' @param stage3 Vector of stage index at time \emph{t}+1 across projection matrix.
#' @param stage2n Vector of stage index at time \emph{t} across projection matrix.
#' @param stage1 Vector of stage index at time \emph{t}-1 across projection matrix.
#' @param sz3 Vector of size at time \emph{t}+1 across projection matrix.
#' @param sz2n Vector of size at time \emph{t} across projection matrix.
#' @param sz1 Vector of size at time \emph{t}-1 across projection matrix.
#' @param fl3 Vector of reproductive status at time \emph{t}+1 across projection 
#' matrix.
#' @param fl2n Vector of reproductive status at time \emph{t} across projection 
#' matrix.
#' @param fl1 Vector of reproductive status at time \emph{t}-1 across projection 
#' matrix.
#' @param ob3 Vector of observation status at time \emph{t}+1 across projection 
#' matrix.
#' @param ob2n Vector of observation status at time \emph{t} across projection 
#' matrix.
#' @param ob1 Vector of observation status at time \emph{t}-1 across projection 
#' matrix.
#' @param immat3 Vector of immaturity status at time \emph{t}+1 across projection 
#' matrix.
#' @param immat2n Vector of immaturity status at time \emph{t} across projection 
#' matrix.
#' @param indata2 Vector indicating whether stage time time \emph{t} in the To
#' stage pair is estimable.
#' @param indata Vector indicating whether the combination of stages at times
#' \emph{t}+1 and \emph{t} in the To stage, and time \emph{t} in the From stage,
#' are estimable.
#' @param aliveandequal Vector indicating whether the transition indicated by the
#' respective From and To stage-pairs is estimable.
#' @param repentry Vector identifying whether stage at time {t}+1 is a reproductive
#' entry stage, and whether stage at time \emph{t} is potentially reproductive.
#' @param ovgivent Vector of given survival-transition probabilities for 
#' replacement.
#' @param ovgivenf Vector of given fecundity rates for replacement.
#' @param binwidth3 Width of size class bins associated with stage in time \emph{t}+1.
#' @param numofsizes4 Number of elements in main matrix.
#' @param fecmod A scalar multiplier for fecundity.
#' @param summedvars Summed variance-covariance terms in Poisson size distribution.
#' @param sigma Standard deviation of Gaussian size distribution.
#' @param jsummedvars Summed variance-covariance terms in Poisson juvenile size
#' distribution.
#' @param jsigma Standard deviation of Gaussian juvenile size distribution.
#' @param maxsize The maximum size to be used in element estimation.
#' @param sizedist Designates whether size is Gaussian (2), Poisson (0), or
#' negative binomial (1) distributed.
#' @param fecdist Designates whether fecundity is Gaussian (2), Poisson (0), or
#' negative binomial (1) distributed.
#' 
#' @return A 6 column matrix showing survival probability, observation probability,
#' reproduction probability, size transition probability, overall 
#' survival-transition probability, and fecundity rate, for each element of the
#' final population projection matrix.
#' 
#' @keywords internal
#' @noRd
jerzeibalowski <- function(survcoefs, obscoefs, sizecoefs, repstcoefs, feccoefs, jsurvcoefs, jobscoefs, jsizecoefs, jrepstcoefs, stage3, stage2n, stage1, sz3, sz2n, sz1, fl3, fl2n, fl1, ob3, ob2n, ob1, immat3, immat2n, indata2, indata, aliveandequal, repentry, ovgivent, ovgivenf, binwidth3, numofsizes4, fecmod, summedvars, sigma, jsummedvars, jsigma, maxsize, sizedist, fecdist) {
    .Call('_lefko3_jerzeibalowski', PACKAGE = 'lefko3', survcoefs, obscoefs, sizecoefs, repstcoefs, feccoefs, jsurvcoefs, jobscoefs, jsizecoefs, jrepstcoefs, stage3, stage2n, stage1, sz3, sz2n, sz1, fl3, fl2n, fl1, ob3, ob2n, ob1, immat3, immat2n, indata2, indata, aliveandequal, repentry, ovgivent, ovgivenf, binwidth3, numofsizes4, fecmod, summedvars, sigma, jsummedvars, jsigma, maxsize, sizedist, fecdist)
}

#' Estimates Mean Population Projection Matrix, Using Summed U and F Matrices
#' 
#' This function estimates the mean population projection matrices, treating the
#' mean as arithmetic across space but either arithmetic or geometric across time.
#' It differs from \code{\link{turbogeodiesel}()} in that it estimates the \code{A} matrix
#' as a sum of the associated \code{U} and \code{F} matrices. Used to power the
#' \code{\link{lmean}()} function.
#' 
#' @param geom Should the mean across time be geometric (1) or arithmetic (0)?
#' @param sparse Should 0s be ignored when some matrices include non-zero entries
#' in common elements?
#' @param numofpops Number of populations to be analyzed.
#' @param numofpatches Number of patches to be analyzed, where this number should
#' include a patch total across all populations.
#' @param numofyears Number of time steps to be analyzed.
#' @param loy2c Matrix denoting the population, patch, and time step designation
#' of each matrix.
#' @param Umats A matrix with all U matrices turned into columns.
#' @param Fmats A matrix with all F matrices turned into columns.
#' 
#' @return A matrix with 3n columns, where n is the sum of the number of patches and
#' populations. Each pop/patch has its own set of three columns denoting survival,
#' fecundity, and the overall sum of the previous two columns.
#' 
#' @keywords internal
#' @noRd
geodiesel <- function(geom, sparse, numofpops, numofpatches, numofyears, loy2c, Umats, Fmats) {
    .Call('_lefko3_geodiesel', PACKAGE = 'lefko3', geom, sparse, numofpops, numofpatches, numofyears, loy2c, Umats, Fmats)
}

#' Estimates Mean Population Projection Matrix
#' 
#' This function estimates the mean population projection matrices, treating the
#' mean as arithmetic across space but either arithmetic or geometric across time.
#' It differs from \code{\link{geodiesel}()} in that it estimates the \code{A} matrix
#' indepenently of the associated \code{U} and \code{F} matrices. Used to power the
#' \code{\link{lmean}()} function.
#' 
#' @param geom Should the mean across time be geometric (1) or arithmetic (0)?
#' @param sparse Should 0s be ignored when some matrices include non-zero entries
#' in common elements?
#' @param numofpops Number of populations to be analyzed.
#' @param numofpatches Number of patches to be analyzed, where this number should
#' include a patch total across all populations.
#' @param numofyears Number of time steps to be analyzed.
#' @param loy2c Matrix denoting the population, patch, and time step designation
#' of each matrix.
#' @param Umats A matrix with all U matrices turned into columns.
#' @param Fmats A matrix with all F matrices turned into columns.
#' @param Amats A matrix with all A matrices turned into columns.
#' 
#' @return A matrix with 3n columns, where n is the sum of the number of patches and
#' populations. Each pop/patch has its own set of three columns denoting survival,
#' fecundity, and the overall projection.
#' 
#' @keywords internal
#' @noRd
turbogeodiesel <- function(geom, sparse, numofpops, numofpatches, numofyears, loy2c, Umats, Fmats, Amats) {
    .Call('_lefko3_turbogeodiesel', PACKAGE = 'lefko3', geom, sparse, numofpops, numofpatches, numofyears, loy2c, Umats, Fmats, Amats)
}

