% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_CCP_lcps.R
\name{create_CCP_lcps}
\alias{create_CCP_lcps}
\title{Calculate Cumulative Cost Paths from Radial Locations}
\usage{
create_CCP_lcps(
  cost_surface,
  location,
  distance,
  radial_points,
  cost_distance = FALSE,
  parallel = FALSE,
  ncores = 1
)
}
\arguments{
\item{cost_surface}{\code{TransitionLayer} (gdistance package). Cost surface to be used in Least Cost Path calculation}

\item{location}{\code{SpatialPoints*} (sp package). Location from which the Least Cost Paths are calculated. If there are multiple SpatialPoints in the supplied data, only the first SpatialPoint is taken into account}

\item{distance}{\code{numeric} value. Distance from centre location to the radial locations}

\item{radial_points}{\code{numeric} value. Number of radial locations around centre location}

\item{cost_distance}{\code{logical}. if TRUE computes total accumulated cost for each Least Cost Path. Default is FALSE}

\item{parallel}{\code{logical}. if TRUE, the Least Cost Paths will be calculated in parallel. Default is FALSE}

\item{ncores}{\code{numeric}. Number of cores used if parallel is TRUE. Default value is 1.}
}
\value{
\code{SpatialLinesDataFrame} (sp package). The resultant object contains least cost paths (number of LCPs is dependent on radial_points argument) calculated from radial locations to a centre location within a specified distance.
}
\description{
Calculates Least Cost Paths from radial locations of a specified distance to the centre location. This is based on the method proposed by Verhagen (2013).
}
\examples{

r <- raster::raster(nrow=50, ncol=50,  xmn=0, xmx=50, ymn=0, ymx=50,
crs='+proj=utm')

r[] <- stats::runif(1:length(r))

slope_cs <- create_slope_cs(r, cost_function = 'tobler')

locs <- sp::spsample(as(raster::extent(r), 'SpatialPolygons'),n=1,'regular')

lcp_network <- create_CCP_lcps(cost_surface = slope_cs, location = locs,
distance = 20, radial_points = 10, cost_distance = FALSE, parallel = FALSE)
}
\references{
Verhagen, P. (2013). On the road to nowhere? Least cost paths, accessibility and the predictive modelling perspective. In Contreras F, Farjas M, Melero FJ (eds). Fusion of cultures. Proceedings of the 38th annual conference on computer applications and quantitative methods in archaeology, Granada, Spain, April 2010. (pp 383-389). Oxford: Archaeopress
}
\author{
Joseph Lewis
}
