% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildings.R
\name{updateBuildingTime}
\alias{updateBuildingTime}
\title{Update the Shadows OSM-Buildings with a POSIXct timestamp}
\usage{
updateBuildingTime(map, time)
}
\arguments{
\item{map}{A map widget object created from \code{\link[leaflet]{leaflet}}.}

\item{time}{a timestamp that can be converted to POSIXct}
}
\description{
Update the Shadows OSM-Buildings with a POSIXct timestamp
}
\examples{
library(leaflet)
library(leaflet.extras2)

leaflet() \%>\%
  addTiles() \%>\%
  addBuildings() \%>\%
  updateBuildingTime(as.POSIXct("2024-09-01 19:00:00 CET")) \%>\%
  setView(13.40, 52.51836, 15)
}
\seealso{
Other OSM-Buildings Plugin: 
\code{\link{addBuildings}()},
\code{\link{setBuildingData}()},
\code{\link{setBuildingStyle}()}
}
\concept{OSM-Buildings Plugin}
