% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/history.R
\name{historyOptions}
\alias{historyOptions}
\title{History Options}
\usage{
historyOptions(
  position = c("topright", "topleft", "bottomleft", "bottomright"),
  maxMovesToSave = 10,
  backImage = "fa fa-caret-left",
  forwardImage = "fa fa-caret-right",
  backText = "",
  forwardText = "",
  backTooltip = "Go to Previous Extent",
  forwardTooltip = "Go to Next Extent",
  backImageBeforeText = TRUE,
  forwardImageBeforeText = FALSE,
  orientation = c("horizontal", "vertical"),
  shouldSaveMoveInHistory = NULL
)
}
\arguments{
\item{position}{Set the position of the History control. Default is
\code{topright}.}

\item{maxMovesToSave}{Number of moves in the history to save before clearing
out the oldest. Default value is 10, use 0 or a negative number to make
unlimited.}

\item{backImage}{The class for the `back` button icon. Default is
\code{"fa fa-caret-left"}.}

\item{forwardImage}{The class for the `forward` button icon. Default is
\code{"fa fa-caret-right"}.}

\item{backText}{The text in the buttons. Default is ''.}

\item{forwardText}{The text in the buttons. Default is ''.}

\item{backTooltip}{Tooltip content. Default is \code{"Go to Previous Extent"}.}

\item{forwardTooltip}{Tooltip content. Default is \code{"Go to Next Extent"}.}

\item{backImageBeforeText}{When both text and image are present, whether to
show the image first or the text first (left to right). Default is
\code{TRUE}}

\item{forwardImageBeforeText}{When both text and image are present, whether
to show the image first or the text first (left to right). Default is
\code{FALSE}}

\item{orientation}{Whether to position the buttons on top of one another or
side-by-side. Default is \code{horizontal}}

\item{shouldSaveMoveInHistory}{A JS callback you can provide that gets called
with every move. return false to not save a move.}
}
\value{
A list of further options for \code{addHistory}
}
\description{
History Options
}
\examples{
library(leaflet)
leaflet() \%>\%
  addTiles() \%>\%
  addHistory(options = historyOptions(
    position = "bottomright",
    maxMovesToSave = 20,
    backText = "Go back",
    forwardText = "Go forward",
    orientation = "vertical"
  ))
}
\references{
\url{https://github.com/cscott530/leaflet-history}
}
\seealso{
Other History Functions: 
\code{\link{addHistory}()},
\code{\link{clearFuture}()},
\code{\link{clearHistory}()},
\code{\link{goBackHistory}()},
\code{\link{goForwardHistory}()}
}
\concept{History Functions}
