% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawOptions.R
\name{handlersOptions}
\alias{handlersOptions}
\title{Options for editing handlers}
\usage{
handlersOptions(
  polyline = list(error = "<strong>Error:</strong> shape edges cannot cross!",
    tooltipStart = "Click to start drawing line.", tooltipCont =
    "Click to start drawing line.", tooltipEnd = "Click to start drawing line."),
  polygon = list(tooltipStart = "Click to start drawing shape.", tooltipCont =
    "Click to start drawing shape.", tooltipEnd = "Click to start drawing shape."),
  rectangle = list(tooltipStart = "Click and drag to draw rectangle."),
  circle = list(tooltipStart = "Click map to place circle marker.", radius = "Radius"),
  marker = list(tooltipStart = "Click map to place marker."),
  circlemarker = list(tooltipStart = "Click and drag to draw circle.")
)
}
\arguments{
\item{polyline}{List of options for polyline tooltips.}

\item{polygon}{List of options for polygon tooltips.}

\item{rectangle}{List of options for rectangle tooltips.}

\item{circle}{List of options for circle tooltips.}

\item{marker}{List of options for marker tooltips.}

\item{circlemarker}{List of options for circlemarker tooltips.}
}
\description{
Customize tooltips for \code{\link{addDrawToolbar}}
}
\examples{
\dontrun{
library(leaflet)
library(leaflet.extras)
leaflet() \%>\%
  addTiles() \%>\%
  addDrawToolbar(
    handlers = handlersOptions(
      polyline = list(
        tooltipStart = "Click It",
        tooltipCont = "Keep going",
        tooltipEnd = "Make it stop"
      ),
    ),
    polylineOptions = T, rectangleOptions = F, circleOptions = F,
    polygonOptions = F, markerOptions = F, circleMarkerOptions = F
  )
}
}
