% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{s.gld.quantile}
\alias{s.gld.quantile}
\title{GLD Quantile Function}
\usage{
s.gld.quantile(probs, p1, p2, p3, p4)
}
\arguments{
\item{probs}{A numeric vector of probabilities.}

\item{p1}{Numeric value representing the first parameter of the distribution (location of the distribution).}

\item{p2}{Numeric value representing the second parameter of the distribution (scale of the distribution).}

\item{p3}{Numeric value representing the third parameter of the distribution (skewness of the distribution).}

\item{p4}{Numeric value representing the fourth parameter of the distribution (kurtosis of the distribution).}
}
\value{
A numeric vector representing the quantiles for each probability in \code{probs}.
}
\description{
This function calculates the quantiles of a Generalized Lambda Distribution (FKML).
}
\details{
It is a helper statistics method in this package and is generally used to plot density function of a GLD distribution.
See the example of \code{\link{s.gld.density.quantile}} function for more details.
}
\examples{
res = s.gld.quantile(c(0.1,0.5,0.95), 0,1,0,0) # standard normal distribution

}
\seealso{
\link{s.gld.density.quantile}
}
