% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetModelCheckItems}
\alias{GetModelCheckItems}
\title{Options for 'Model Check Items'}
\usage{
GetModelCheckItems(
  estimation = TRUE,
  maxConditionNumber = 1.7e+308,
  minObsCount = 0L,
  minDof = 0L,
  minOutSim = 0L,
  minR2 = -1.7e+308,
  maxAic = 1.7e+308,
  maxSic = 1.7e+308,
  prediction = FALSE,
  predictionBoundMultiplier = 4
)
}
\arguments{
\item{estimation}{(bool) If true, model is estimated with all data. If false, you might get a 'best model' that cannot be estimated.}

\item{maxConditionNumber}{(double) Maximum value for the condition number (if implemented in the search).}

\item{minObsCount}{(int) Minimum value for the number of observations. Use 0 to disable.}

\item{minDof}{(int) Minimum value for the degrees of freedom (equation-wise). Use 0 to disable.}

\item{minOutSim}{(int) Minimum value for the number of valid out-of-sample simulations (if implemented in the search).}

\item{minR2}{(double) Minimum value for R2 (if implemented in the search).}

\item{maxAic}{(double) Maximum value for AIC (if implemented in the search).}

\item{maxSic}{(double) Maximum value for SIC (if implemented in the search).}

\item{prediction}{(bool) If true, model data is predicted given all data. If false, you might get a 'best model' that cannot be used in prediction.}

\item{predictionBoundMultiplier}{(double) If positive, a bound is created by multiplying this value to the average growth rate. A model is ignored, if its prediction lies outside of this bound.}
}
\value{
A list with the given options.
}
\description{
Options for 'Model Check Items'
}
