% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldsep-package.R
\docType{package}
\name{ldsep-package}
\alias{ldsep-package}
\alias{ldsep}
\title{Linkage Disequilibrium Shrinkage Estimation for Polyploids}
\description{
Estimate haplotypic or composite pairwise linkage disequilibrium
(LD) in polyploids, using either genotypes or genotype likelihoods. Support is
provided to estimate the popular measures of LD: the LD coefficient D,
the standardized LD coefficient D', and the Pearson correlation
coefficient r. All estimates are returned with corresponding
standard errors. These estimates and standard errors can then be used
for shrinkage estimation.
}
\section{Functions}{


The main functions are:
\describe{
\item{\code{\link{ldest}()}}{Estimates pairwise LD.}
\item{\code{\link{mldest}()}}{Iteratively apply \code{\link{ldest}()}
across many pairs of SNPs.}
\item{\code{\link{sldest}()}}{Iteratively apply \code{\link{ldest}()}
along a sliding window of fixed length.}
\item{\code{\link{plot.lddf}()}}{Plot method for the output of
\code{\link{mldest}()} and \code{\link{sldest}()}.}
\item{\code{\link{format_lddf}()}}{Format the output of
\code{\link{mldest}()} and \code{\link{sldest}()} into a matrix.}
\item{\code{\link{ldshrink}()}}{Shrink correlation estimates
using adaptive shrinkage (Stephens, 2017; Dey and Stephens, 2018).}
}
}

\section{Citation}{

If you find the methods in this package useful, please run the following
in R for citation information: \code{citation("ldsep")}
}

\author{
David Gerard
}
