% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_generate_policy_mt.R
\name{rl_generate_policy_mt}
\alias{rl_generate_policy_mt}
\title{Function performs RL and generates model policy for each Market Type}
\usage{
rl_generate_policy_mt(x, states, actions, control)
}
\arguments{
\item{x}{- Dataframe containing trading data}

\item{states}{- Character vector, Selected states of the System}

\item{actions}{- Character vector, Selected actions executed under environment}

\item{control}{- List, control parameters as defined in the Reinforcement Learning Package}
}
\value{
Function returns data frame with reinforcement learning model policy
}
\description{
This function will perform Reinforcement Learning using Trading Data.
It will suggest whether or not it is better to keep using trading systems or not.
Function is just using results of the past performance to generate the recommendation (not a holy grail).
}
\details{
Initial policy is generated using a dummy zero values.
This way function starts working directly from the first observation.
However policy 'ON' value will only be generated once the Q value is greater than zero
}
\examples{

library(dplyr)
library(magrittr)
library(ReinforcementLearning)
library(lazytrade)
data(trading_systemDF)
states <- c("BUN", "BUV", "BEN", "BEV", "RAN", "RAV")
actions <- c("ON", "OFF")
control <- list(alpha = 0.7, gamma = 0.3, epsilon = 0.1)
rl_generate_policy_mt(x = trading_systemDF,
                      states = states,
                      actions = actions,
                      control = control)


}
