% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazyraster.R
\name{as_raster}
\alias{as_raster}
\title{Convert to in-memory raster}
\usage{
as_raster(x, dim = NULL, resample = "NearestNeighbour", native = FALSE)
}
\arguments{
\item{x}{a \link{lazyraster}}

\item{dim}{dimensions, pixel size in rows and columns}

\item{resample}{resampling method, see \link[vapour:vapour_read_raster]{vapour::vapour_read_raster}}

\item{native}{return raster at native resolution, default is \code{FALSE}}
}
\value{
a regular raster 'BasicRaster' in-memory object
}
\description{
Create an actual \link[raster:raster]{raster::raster} object by breaking the lazy
contract and demanding pixel values at a given resolution.
}
\details{
Control the dimensions and method for resampling with the 'dim' and
'resample' arguments.

When \code{native = TRUE} the \code{dim} argument is ignored, and no resampling is performed.
}
