% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lawn_feature.R
\name{lawn_feature}
\alias{lawn_feature}
\title{Create a Feature}
\usage{
lawn_feature(geometry, properties = c(), lint = FALSE)
}
\arguments{
\item{geometry}{(character/json) Any geojson geometry.}

\item{properties}{(list) list of properties, must be named}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\description{
Create a Feature
}
\examples{
\dontrun{
# points
## single point
pt <- '{"type":"Point","coordinates":[-75.343,39.984]}'
lawn_feature(pt)

## with properties
lawn_feature(pt, properties = list(foo = "bar"))

## many points in a list
pts <- list(
   lawn_point(c(-75.343, 39.984))$geometry,
   lawn_point(c(-75.833, 39.284))$geometry,
   lawn_point(c(-75.534, 39.123))$geometry
)
lapply(pts, lawn_feature)
}
}
\seealso{
Other data functions: 
\code{\link{lawn_featurecollection}()},
\code{\link{lawn_filter}()},
\code{\link{lawn_geometrycollection}()},
\code{\link{lawn_linestring}()},
\code{\link{lawn_multilinestring}()},
\code{\link{lawn_multipoint}()},
\code{\link{lawn_multipolygon}()},
\code{\link{lawn_point}()},
\code{\link{lawn_polygon}()},
\code{\link{lawn_random}()},
\code{\link{lawn_remove}()},
\code{\link{lawn_sample}()}
}
\concept{data functions}
