% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbox_polygon.R
\name{lawn_bbox_polygon}
\alias{lawn_bbox_polygon}
\title{Make a polygon from a bounding box}
\usage{
lawn_bbox_polygon(bbox)
}
\arguments{
\item{bbox}{An array of bounding box coordinates in the form:
\verb{[xLow, yLow, xHigh, yHigh]}.}
}
\value{
A \link{data-Polygon} representation of the bounding box.
}
\description{
Takes a bbox and returns an equivalent polygon \link{data-Polygon}.
}
\examples{
bbox <- c(0, 0, 10, 10)
lawn_bbox_polygon(bbox)
\dontrun{
lawn_bbox_polygon(bbox) \%>\% view
lawn_bbox_polygon(c(1, 3, 5, 50)) \%>\% view
}
}
\seealso{
Other measurements: 
\code{\link{lawn_along}()},
\code{\link{lawn_area}()},
\code{\link{lawn_bbox}()},
\code{\link{lawn_bearing}()},
\code{\link{lawn_center_of_mass}()},
\code{\link{lawn_center}()},
\code{\link{lawn_centroid}()},
\code{\link{lawn_destination}()},
\code{\link{lawn_distance}()},
\code{\link{lawn_envelope}()},
\code{\link{lawn_extent}()},
\code{\link{lawn_line_distance}()},
\code{\link{lawn_midpoint}()},
\code{\link{lawn_point_on_feature}()},
\code{\link{lawn_pt2line_distance}()},
\code{\link{lawn_square}()}
}
\concept{measurements}
