% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view.R
\name{view}
\alias{view}
\alias{view_}
\title{Visualize geojson}
\usage{
view(x)

view_(...)
}
\arguments{
\item{x}{Input, a geojson character string or list.}

\item{...}{Any geojson object, as list, json, or point, polygon, etc. class.}
}
\value{
Opens a map with the geojson object(s).
}
\description{
Visualize geojson
}
\details{
\code{view_} is a special interface to \code{view} to accept
arbitrary input via \code{...}.
}
\examples{
\dontrun{
# from character string
view(lawn_data$polygons_average)
view(lawn_data$filter_features)
view(lawn_data$polygons_within)
view(lawn_data$polygons_count)

# from json (a jsonlite class)
library(jsonlite)
x <- minify(lawn_data$points_count)
class(x)
view(x)

# from a list (a single object)
library("jsonlite")
x <- fromJSON(lawn_data$polygons_average, FALSE)
view(x)

# From a list of many objects
x <- list(
 lawn_point(c(-75.343, 39.984), properties = list(name = 'Location A')),
 lawn_point(c(-75.833, 39.284), properties = list(name = 'Location B')),
 lawn_point(c(-75.534, 39.123), properties = list(name = 'Location C'))
)
view(x)

# Use view_ to pass in arbitrary objects that will be combined
view_(
 lawn_point(c(-75.343, 39.984), properties = list(name = 'Location A')),
 lawn_point(c(-75.833, 39.284), properties = list(name = 'Location B')),
 lawn_point(c(-75.534, 39.123), properties = list(name = 'Location C'))
)

## another eg, smile :)
l1 <- list(
   c(-69.9609375, 35.460669951495305),
   c(-78.75, 39.095962936305504),
   c(-87.1875, 39.36827914916011),
   c(-92.46093749999999, 36.03133177633189)
)
l2 <- list(
   c(-46.0546875, 8.7547947),
   c(-33.0468750, -0.7031074),
   c(-14.0625000, 0.0000000),
   c(-0.3515625,  9.4490618)
)
l3 <- list(
   c(-1.40625, 38.81152),
   c(14.76562, 45.33670),
   c(23.20312, 45.58329),
   c(33.04688, 39.63954)
)
view_(lawn_point(c(-30, 20)),
   lawn_linestring(l1),
   lawn_linestring(l2),
   lawn_linestring(l3)
)

# From a geo_list object from geojsonio package
# library("geojsonio")
# vecs <- list(c(100.0,0.0), c(101.0,0.0), c(101.0,1.0),
  c(100.0,1.0), c(100.0,0.0))
# x <- geojson_list(vecs, geometry="polygon")
# view_(x)
# view_(x, lawn_point(c(101, 0)))
}
}
