% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrateType1.R
\name{calibrateType}
\alias{calibrateType}
\alias{calibrateType1}
\title{Simulation Study Assessing Bias and Type 1 Error}
\usage{
calibrateType1(object, null, n, n.rep, F.test = FALSE,
  generative.object = NULL, generative.coef = NULL, true.coef = NULL,
  n.true = 1e+06, round.true = 2, bootstrap = FALSE,
  type.bootstrap = c("perc", "stud", "bca"), n.bootstrap = 1000,
  checkType1 = FALSE, checkType2 = FALSE, dir.save = NULL,
  label.file = NULL, seed = NULL, trace = 2)
}
\arguments{
\item{object}{a \code{lvm} object defining the model to be fitted.}

\item{null}{[character vector] names of the coefficient whose value will be tested against 0.}

\item{n}{[integer vector, >0] sample size(s) considered in the simulation study.}

\item{n.rep}{[integer, >0] number of simulations per sample size.}

\item{F.test}{[logical] should a multivariate Wald test be perform testing simultaneously all the null hypotheses?}

\item{generative.object}{[lvm] object defining the statistical model generating the data.}

\item{generative.coef}{[name numeric vector] values for the parameters of the generative model.
Can also be \code{NULL}: in such a case the coefficients are set to default values decided by lava (usually 0 or 1).}

\item{true.coef}{[name numeric vector] expected values for the parameters of the fitted model.}

\item{n.true}{[integer, >0] sample size at which the estimated coefficients will be a reliable approximation of the true coefficients.}

\item{round.true}{[integer, >0] the number of decimal places to be used for the true value of the coefficients. No rounding is done if \code{NULL}.}

\item{bootstrap}{[logical] should bootstrap resampling be performed?}

\item{type.bootstrap}{[character vector]}

\item{n.bootstrap}{[integer, >0] the number of bootstrap sample to be used for each bootstrap.}

\item{checkType1}{[logical] returns an error if the coefficients associated to the null hypotheses do not equal 0.}

\item{checkType2}{[logical] returns an error if the coefficients associated to the null hypotheses equal 0.}

\item{dir.save}{[character] path to the directory were the results should be exported.
Can also be \code{NULL}: in such a case the results are not exported.}

\item{label.file}{[character] element to include in the file name.}

\item{seed}{[integer, >0] seed value that will be set at the beginning of the simulation to enable eproducibility of the results.
Can also be \code{NULL}: in such a case no seed is set.}

\item{trace}{[interger] should the execution of the function be trace. Can be 0, 1 or 2.}
}
\value{
An object of class \code{calibrateType1}.
}
\description{
Perform a simulation study over one or several sample size
to assess the bias of the estimate
and the type 1 error of the Wald test and robust Wald test
}
\examples{
#### generative model ####
m.Sim <- lvm(c(Y1[mu1:sigma]~1*eta,
               Y2[mu2:sigma]~1*eta,
               Y3[mu3:sigma]~1*eta,
               eta~beta1*Group+beta2*Gender))
latent(m.Sim) <- ~eta
categorical(m.Sim, labels = c("M","F")) <- ~Gender

vec.par <- c(mu2 = 0, ## mu1 is set to 0 by default
             mu3 = -0.37,
             "eta" = -2.74,
             beta1 = -1.20,
             beta2 = 0,
             sigma = 1.46,
             "eta~~eta" = 1.63)

#### parameters to test ####
null <- c("Y2","eta~GenderF")

#### launch simulation: same model generation fit ####
\dontrun{
res <- calibrateType1(m.Sim, null = null, n = c(20,30,40), n.rep = 50, generative.coef = vec.par)
autoplot(res, type = "bias")
autoplot(res, type = "type1error")
}
\dontshow{
res <- calibrateType1(m.Sim, null = null, n = c(20,30,40), n.true = 1e3, n.rep = 2, generative.coef = vec.par)
}
}
\seealso{
\code{link{autoplot.calibrateType1}} for a graphical display of the bias or of the type 1 error.
}
\author{
Brice Ozenne
}
