% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkData.R
\name{checkData}
\alias{checkData}
\alias{checkData.lvm}
\title{Check that Validity of the Dataset}
\usage{
checkData(x, data, trace)

\method{checkData}{lvm}(x, data, trace = TRUE)
}
\arguments{
\item{x}{a lvm model}

\item{data}{the dataset containing the variables used to estimate the lvm.}

\item{trace}{[logical] should a message be output to indicate the outcome of the check?}
}
\description{
Check the validity of the dataset used to estimate a lvm.
}
\examples{
m <- lvm()
regression(m) <- c(y1,y2,y3)~u
regression(m) <- u~x
latent(m) <- ~u

d <- sim(m,1e2)

try(checkData(m, d)) # return an error

checkData(m, d[,-4])

try(checkData(m, d[,-(3:4)])) # return an error

}
