% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{qqPlot}
\alias{qqPlot}
\alias{qqPlot,lcModel-method}
\title{Quantile-quantile plot}
\usage{
\S4method{qqPlot}{lcModel}(object, byCluster = FALSE, ...)
}
\arguments{
\item{object}{The \code{lcModel} object.}

\item{byCluster}{Whether to plot the Q-Q line per cluster}

\item{...}{Additional arguments passed to \code{\link[qqplotr:stat_qq_band]{qqplotr::geom_qq_band()}}, \code{\link[qqplotr:stat_qq_line]{qqplotr::stat_qq_line()}}, and \code{\link[qqplotr:stat_qq_point]{qqplotr::stat_qq_point()}}.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the quantile-quantile (Q-Q) plot for the fitted \code{lcModel} object. This function is based on the \pkg{qqplotr} package.
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time", nClusters = 3)
model <- latrend(method, latrendData)

if (require("ggplot2") && require("qqplotr")) {
  qqPlot(model)
}
}
\seealso{
\link{residuals.lcModel} \link{metric} \link{plotClusterTrajectories}

Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric,lcModel,lcModel-method}},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
