% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodFeature.R
\name{lcMethodFeature}
\alias{lcMethodFeature}
\title{Feature-based clustering}
\usage{
lcMethodFeature(
  response,
  representationStep,
  clusterStep,
  standardize = scale,
  center = meanNA,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  ...
)
}
\arguments{
\item{response}{The name of the response variable.}

\item{representationStep}{A \code{function} with signature \verb{function(method, data)} that computes the representation per strata, returned as a \code{matrix}.
Alternatively, \code{representationStep} is a pre-computed representation \code{matrix}.}

\item{clusterStep}{A \code{function} with signature \verb{function(repdata)} that outputs a \code{lcModel}.}

\item{standardize}{A \code{function} to standardize the output \code{matrix} of the representation step. By default, the output is shifted and rescaled to ensure zero mean and unit variance.}

\item{center}{Optional \code{function} for computing the longitudinal cluster centers, with signature \code{(x)}.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identification variable.}

\item{...}{Additional arguments.}
}
\description{
Feature-based clustering.
}
\section{Linear regresion & k-means example}{

In this example we define a feature-based approach where each trajectory is represented using a linear regression model.
The coefficients of the trajectories are then clustered using k-means.

Note that this method is already implemented as \code{\link[=lcMethodLMKM]{lcMethodLMKM()}}.

Representation step:
\preformatted{
repStep <- function(method, data, verbose) {
  library(data.table)
  library(magrittr)
  xdata = as.data.table(data)
  coefdata <- xdata[,
    lm(method$formula, .SD) %>% coef() %>% as.list(),
    keyby = c(method$id)
  ]
  # exclude the id column
  coefmat <- subset(coefdata, select = -1) %>% as.matrix()
  rownames(coefmat) <- coefdata[[method$id]]
  return(coefmat)
}
}

Cluster step:
\preformatted{
clusStep <- function(method, data, repMat, envir, verbose) {
  km <- kmeans(repMat, centers = method$nClusters)

  lcModelCustom(
    response = method$response,
    method = method,
    data = data,
    trajectoryAssignments = km$cluster,
    clusterTrajectories = method$center,
    model = km
   )
}
}

Now specify the method and fit the model:
\preformatted{
data(latrendData)
method <- lcMethodFeature(
  formula = Y ~ Time,
  response = "Y",
  id = "Id",
  time = "Time",
  representationStep = repStep,
  clusterStep = clusStep

model <- latrend(method, data = latrendData)
)
}
}

\seealso{
Other lcMethod implementations: 
\code{\link{getArgumentDefaults}()},
\code{\link{getArgumentExclusions}()},
\code{\link{lcMethod-class}},
\code{\link{lcMethodAkmedoids}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodCustom}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodLongclust}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodRandom}},
\code{\link{lcMethodStratify}}
}
\concept{lcMethod implementations}
