% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latrend.R
\name{transformLatrendData}
\alias{transformLatrendData}
\alias{transformLatrendData,data.frame-method}
\alias{transformLatrendData,matrix-method}
\alias{transformLatrendData,call-method}
\title{Transform latrend input data into the right format}
\usage{
transformLatrendData(object, id, time, response, envir)

\S4method{transformLatrendData}{data.frame}(object, id, time, response, envir)

\S4method{transformLatrendData}{matrix}(object, id, time, response, envir)

\S4method{transformLatrendData}{call}(object, id, time, response, envir)
}
\arguments{
\item{object}{The data object to transform.}

\item{id}{The name of the trajectory identifier variable.}

\item{time}{The name of the time variable.}

\item{response}{The name of the response variable.}

\item{envir}{The \code{environment} used to evaluate the data object in (e.g., in case \code{object} is of type \code{call}).}
}
\value{
A \code{data.frame} with an id, time, and measurement columns.
}
\description{
This function is also responsible for checking whether the input data is valid, such that the fitting process can fail early.
}
