% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{max.lcModels}
\alias{max.lcModels}
\title{Select the lcModel with the highest metric value}
\usage{
\method{max}{lcModels}(x, name, ...)
}
\arguments{
\item{x}{The \code{lcModels} object.}

\item{name}{The name of the internal metric.}

\item{...}{Additional arguments.}
}
\value{
The lcModel with the highest metric value
}
\description{
Select the lcModel with the highest metric value
}
\examples{
data(latrendData)
baseMethod <- lcMethodKML(response = "Y", id = "Id", time = "Time")
kml1 <- latrend(baseMethod, nClusters = 1, latrendData)
kml2 <- latrend(baseMethod, nClusters = 2, latrendData)
kml3 <- latrend(baseMethod, nClusters = 3, latrendData)
models <- lcModels(kml1, kml2, kml3)
max(models, 'WRSS')
}
\seealso{
\link{min.lcModels} \link{externalMetric}
}
