% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters.R
\name{clusterVisualK}
\alias{clusterVisualK}
\title{Visualize K-Means Clusters for Several K}
\usage{
clusterVisualK(df, ks = 2:6, ...)
}
\arguments{
\item{df}{Dataframe}

\item{ks}{Integer vector. Which k should be tested?}

\item{...}{Additional parameters passed to \code{clusterKmeans}}
}
\value{
List. Plot and data.frame results of clustering \code{df}
data.frame into \code{ks} integer clusters.
}
\description{
Visualize cluster data for assorted values of k.
}
\examples{
Sys.unsetenv("LARES_FONT") # Temporal
data("iris")
df <- subset(iris, select = c(-Species))
df <- df[sample(nrow(df)), ]

# Calculate and plot
result <- clusterVisualK(df, ks = 2:4)
plot(result$plot)

# You can use the data generated as well
lapply(result$data, function(x) head(x$cluster, 10))
}
\seealso{
Other Clusters: 
\code{\link{clusterKmeans}()},
\code{\link{clusterOptimalK}()},
\code{\link{reduce_pca}()},
\code{\link{reduce_tsne}()}
}
\concept{Clusters}
