% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_opts}
\alias{check_opts}
\title{Validate options within vector}
\usage{
check_opts(inputs, opts, type = "all", not = "stop", quiet = TRUE)
}
\arguments{
\item{inputs}{Vector character}

\item{opts}{Vector character}

\item{type}{Character. Options: all, any}

\item{not}{Character. Options: stop, message, print, return}

\item{quiet}{Boolean. Keep quiet? If not, returns TRUE or FALSE}
}
\value{
Boolean. Result of \code{inputs} in \code{opts} (options).
Depending on \code{type} and/or \code{stop} arguments,
errors or messages will be shown.
}
\description{
This function validates if inputs match all/any of your options
and return error/message with possible options to use.
}
\examples{
opts <- c("A", "B", "C")
# Let's check the "all" logic
check_opts(inputs = c("A", "B"), opts, quiet = FALSE)
check_opts(inputs = c("X"), opts, not = "message", quiet = FALSE)
check_opts(inputs = c("A","X"), opts, not = "warning")
# Now let's check the "any" logic
check_opts(inputs = c("A","X"), opts, type = "any")
check_opts(inputs = c("X"), opts, type = "any", not = "message")
check_opts(inputs = c("A", NA), opts, type = "any")
# Final trick: just ignore results
check_opts(inputs = "X", opts, not = "invisible")
}
