% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_metrics.R
\name{errors}
\alias{errors}
\alias{rmse}
\alias{mae}
\alias{mse}
\alias{mape}
\alias{rsq}
\alias{rsqa}
\title{Calculate Continuous Values Errors}
\usage{
errors(tag, score)

rmse(tag, score)

mae(tag, score)

mse(tag, score)

mape(tag, score)

rsq(tag, score)

rsqa(tag, score)
}
\arguments{
\item{tag}{Vector. Real known label}

\item{score}{Vector. Predicted value or model's result}
}
\value{
data.frame or numeric values results for multiple error
metrics on continuous numerical vectors inputs.
}
\description{
This function lets the user calculate all errors and R squared 
simultaneously.

This function lets the user calculate Root Mean Squared Error

This function lets the user calculate Mean Absolute Error

This function lets the user calculate Mean Squared Error

This function lets the user calculate Mean Squared Error

This function lets the user calculate R Squared

This function lets the user calculate Adjusted R Squared
}
\examples{
data(dfr) # Results for AutoML Predictions
head(dfr$regr)
df <- errors(dfr$regr$tag, dfr$regr$score)
head(df)
}
\seealso{
Other Model metrics: 
\code{\link{ROC}()},
\code{\link{conf_mat}()},
\code{\link{gain_lift}()},
\code{\link{loglossBinary}()},
\code{\link{model_metrics}()}
}
\concept{Model metrics}
