% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{compute_audpc100S}
\alias{compute_audpc100S}
\title{Compute AUDPC in a 100\% susceptible field}
\usage{
compute_audpc100S(
  disease = "rust",
  hostType = "growingHost",
  seed = 12345,
  area = 1e+06
)
}
\arguments{
\item{disease}{a disease name, among "rust" (default) and "mildew"}

\item{hostType}{cultivar type, among: "growingHost" (default), "nongrowingHost", "grapevine".}

\item{seed}{an integer used as seed value (for random number generator).}

\item{area}{area of the field (must be in square meters).}
}
\value{
The AUDPC value (numeric)
}
\description{
Compute AUDPC in a single field cultivated with a susceptible cultivar.
}
\details{
audpc100S is the average AUDPC computed in a non-spatial simulation.
}
\examples{
\dontrun{
compute_audpc100S("rust", "growingHost", area=1E6)
compute_audpc100S("mildew", "grapevine", area=1E6)
}
}
\seealso{
\link{loadOutputs}
}
