% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotevolQR.R
\name{plotevolQR}
\alias{plotevolQR}
\title{Ploting pathotype frequencies}
\usage{
plotevolQR(pathRES, nIncr, trait, I_aggrProp, D, nTS, nYears, nTSpY)
}
\arguments{
\item{pathRES}{the path of the repository where the graphic will be generated}

\item{nIncr}{number of pathotypes}

\item{trait}{index of the evolving trait (1 to 4 for major genes, 5 to 8 for quantitative resistance traits against infection rate (5), latent period (6), reproduction rate (7) and infectious period duration (8))}

\item{I_aggrProp}{a matrix giving the frequency of every pathotype (row) for every time-step (columns)}

\item{D}{durability of the trait}

\item{nTS}{number of simulated time-steps}

\item{nYears}{number of simulated years}

\item{nTSpY}{number of time-steps per year}
}
\description{
Plot the dynamic of pathotype frequencies in a tiff file.
}
\examples{
\dontrun{
freqMatrix <- matrix(0, nrow=2, ncol=100)
freqMatrix[2,26:100] <- (26:100)/100
freqMatrix[1,] <- 1-freqMatrix[2,]
plotevolQR(getwd(), nIncr=2, trait=1, freqMatrix, D=25, nTS=100,nYears=10,nTSpY=10)
}
}
