% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_writeESRI.R
\name{util_writeESRI}
\alias{util_writeESRI}
\alias{util_writeESRI.RasterLayer}
\title{util_writeESRI}
\usage{
util_writeESRI(x, filepath)

\method{util_writeESRI}{RasterLayer}(x, filepath)
}
\arguments{
\item{x}{Raster* object}

\item{filepath}{path where to write the raster to file}
}
\description{
Export raster objects as ESRI ascii files.
}
\details{
\code{raster::writeRaster} or \code{SDMTools::write.asc} both
export files that are recognised by most GIS software, nevertheless
they both have UNIX linebreaks.
Some proprietary software (like SPIP for example) require an exact 1:1
replica of the output of ESRI's ArcMap, which as a Windows software
has no carriage returns at the end of each line.
\code{util_writeESRI} should therefore only be used if you need this,
otherwise \code{raster::writeRaster} is the better fit for exporting
raster data in R.
}
\examples{
\dontrun{
util_writeESRI(gradient_landscape, "gradient_landscape.asc")
}

}
