% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_num.R
\name{as_num}
\alias{as_num}
\title{Convert all Suitable Character Variables to Numeric}
\usage{
as_num(data, nan2na = TRUE, inf2na = TRUE)
}
\arguments{
\item{data}{a data.frame object.}

\item{nan2na}{a logical argument. TRUE if the non-case-sensitive string "nan"
should be converted to NA.}

\item{inf2na}{a logical argument. TRUE if the non-case-sensitive strings
"inf" or "-inf should be converted to NA.}
}
\value{
a data.frame object with all applicable character variables coerced
to numeric.
}
\description{
\code{as_num} identifies the character variables of a data.frame that can be
coerced to numeric without generating new NA values and, for those variables
where this can be done, it makes those conversions (similar to Stata's
destring command).
}
\details{
Core labelr functions coerce integers to characters and back, which \code{as_num}
facilitates. Note that character values of "NA" (including "na", "Na",
and "nA") will be converted to NA and, by default, so will other "irregular"
values (in the sense of \code{check_irregular}).
}
\examples{
set.seed(123)
x1 <- runif(10)
x2 <- as.character(sample(c(1:20), 10, replace = TRUE))
x3 <- sample(letters, size = 10, replace = TRUE)
df <- data.frame(x1, x2, x3)
head(df, 3)
sapply(df, class)
class(df$x2)

df <- as_num(df)
head(df,3)
sapply(df, class)
class(df$x2)
}
