\name{\%._.\%}
\alias{._.}
\alias{\%._.\%}
\alias{labeledLoop}
\alias{labeledLoop-package}
\alias{package-labeledLoop}
\title{Labeled loop and break}
\usage{
  label \%._.\% statement

  ._.(label = ".")
}
\arguments{
  \item{label}{label for this loop}

  \item{statement}{statement such as \code{for},
  \code{while} etc.}
}
\description{
  \code{label \%._.\% for} generates labeled loop. To
  escape from this loop, replace `break` with
  \code{._.(label)}. Pseudo-anonymous labeled loop can be
  generated by \code{.\%._.\%} and break by \code{._.()}.
}
\examples{
. \%._.\% for(i in 1:3) {
  foo \%._.\% for (j in 1:3) {
    orz \%._.\% for (k in 1:3) {
      print(c(i, j, k))

      if (i == 3 && j == 3 && k == 2) {
        cat("escape from outmost loop\\n")
        ._.() # break
      }

      if (i == 2 && j == 2) {
        cat("escape from innermost loop (orz)\\n")
        ._.(orz) # break
      }

      if (i == 1 && j == 1 && k == 2) {
        cat("escape from foo\\n")
        ._.(foo) # break
      }
    }
  }
}
}

