% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drsub.R
\name{commcore}
\alias{ckGV}
\alias{closure}
\alias{commcore}
\alias{distill}
\alias{kzpdr.pairs}
\alias{kzpdr.proj}
\alias{kzpdr.rec}
\alias{shade}
\alias{tight}
\alias{tolerance}
\title{Internal Function Used In Wave Parameter Estimation}
\usage{
commcore(pool, STEP = 1, DIFF = 1, digit = 0)

kzpdr.proj(rec = ls(1))

kzpdr.rec(rec = ls(1), md5 = "")

kzpdr.pairs(rec = ls(1))

ckGV(angle, rec)

shade(alpha, gs, cc = 3)

tight(alpha, gs, cc = 3)

tolerance(tm2, scale, tol = 1)

closure(tm2, mdc, sc)

distill(tm2, mdc)
}
\arguments{
\item{pool}{List for the potential parameters.}

\item{STEP}{The tolerance interval for a data element.
Defaults to 1.}

\item{DIFF}{The allowed absents times for a suggested 
common element. Default value is 1.}

\item{digit}{Significant digits. Defaults to 0.}

\item{rec}{Data frame or list of the outputs from function \code{kzpdr}. 
It includes the marked spike frequencies and sampling directions.
Default is for searching from all variables in the R environment.}

\item{md5}{MD5 code for the specified data array. The returned data will be
the records for the array with the same MD5 code. The default is
to return the first record variable in alphabet order.}

\item{angle}{Vector of sampling directions in radian.}

\item{alpha}{Vector of checked directions in degree.}

\item{gs}{Vector of directions for all available periodograms.}

\item{cc}{Tolerance of wave parameters. Defaults to 3.}

\item{tm2}{Data frame. Internal data table for potential parameters.}

\item{scale}{The scale of gridding data.}

\item{mdc}{Integer. Specified approximate size of the closure.}

\item{sc}{Numeric. Specified tolerance level of the cluster.}
}
\description{
Function \code{commcore} is designed to find the common elements 
in a given list, which is the pool of all potential parameters. The
common elements should appear in most data groups of paired directional
periodograms.

	\code{kzpdr.rec} will search all variables in R global environment  
for available records of directional periodograms, and return the 
specified part as output. 

\code{kzpdr.pairs} returns a list of all available pairs of sampling 
directions and the counts number for the spikes on each direction.

\code{kzpdr.prj} is used for calculating the projected parameters
based on directional periodograms.

Function \code{ckGV} refers to a given record set of directional
periodogram and checks duplicated directions. The returned value is a 
list of sampling directions without those duplications.

\code{shade} decides if a spectral signals would sometime disappear 
in the given sampling directions. The return value is a vector of 0/1. 
0 means the signal should be seen in all given directions. 0 means not. 
2 and larger may happen when there are very closed sampling angles.

\code{tight} is used to get the minimum difference in a group of
potential directions or frequencies. 

\code{tolerance} is used to calculate the tolerance of the estimations.

Function \code{closure} returns the closure of the nearest neighbors. 

\code{distill} excludes the duplicate supports of a cluster. Usually,
duplications are supports for the same parameters but from the same pairs,
grouping under the given tolerance condition.
}
\keyword{internal}

