## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
# install.packages("crosstalk")
# Install kpiwidget from CRAN or GitHub
# install.packages("kpiwidget")
# devtools::install_github("your_github/kpiwidget")

## ----setup--------------------------------------------------------------------
library(kpiwidget)
library(crosstalk)
library(dplyr)
library(htmltools)

## -----------------------------------------------------------------------------
# Create a shared data object with row numbers as keys
df_shared <- SharedData$new(mtcars, key = ~ 1:nrow(mtcars), group = "mtcars_group")

## -----------------------------------------------------------------------------
filter_checkbox("gear", "Gear", df_shared, ~gear, inline = TRUE)

## -----------------------------------------------------------------------------
kpiwidget(
  data = df_shared,
  column = "mpg",
  height = "25px"
)

## -----------------------------------------------------------------------------
kpiwidget(
  data = df_shared,
  column = "mpg",
  kpi = "sum",
  height = "25px"
)

## -----------------------------------------------------------------------------
kpiwidget(
  data = df_shared,
  column = "mpg",
  kpi = "mean",
  height = "25px"
)

## -----------------------------------------------------------------------------
kpiwidget(
  data = df_shared,
  column = "mpg",
  kpi = "min",
  height = "25px"
)

## -----------------------------------------------------------------------------
kpiwidget(
  data = df_shared,
  column = "mpg",
  kpi = "max",
  height = "25px"
)

## -----------------------------------------------------------------------------
kpiwidget(
  data = df_shared,
  column = "mpg",
  kpi = "count",
  height = "25px"
)

## -----------------------------------------------------------------------------
kpiwidget(
  data = df_shared,
  column = "cyl",
  kpi = "distinctCount",
  height = "25px"
)

## -----------------------------------------------------------------------------
kpiwidget(
  data = df_shared,
  column = "mpg",
  kpi = "mean",
  comparison = "ratio",
  group1 = ~ cyl == 4,
  height = "25px"
)

## -----------------------------------------------------------------------------
kpiwidget(
  data = df_shared,
  column = "mpg",
  kpi = "mean",
  comparison = "ratio",
  group1 = ~ cyl == 4,
  group2 = ~ cyl == 6,
  height = "25px"
)

## -----------------------------------------------------------------------------
kpiwidget(
  data = df_shared,
  column = "mpg",
  kpi = "count",
  comparison = "share",
  group1 = ~ cyl == 4,
  height = "25px"
)

## -----------------------------------------------------------------------------
kpiwidget(
  data = df_shared,
  column = "mpg",
  kpi = "count",
  comparison = "share",
  group1 = ~ cyl == 4,
  group2 = ~ cyl %in% c(4, 6),
  height = "25px"
)

## -----------------------------------------------------------------------------
kpiwidget(
  data = df_shared,
  column = "mpg",
  kpi = "count",
  selection = ~ cyl %in% c(4, 6),
  comparison = "share",
  group1 = ~ cyl == 4,
  height = "25px"
)

## -----------------------------------------------------------------------------
kpiwidget(
  data = df_shared,
  column = "mpg",
  kpi = "mean",
  decimals = 3,
  height = "25px"
)

## -----------------------------------------------------------------------------
kpiwidget(
  data = df_shared,
  column = "disp",
  kpi = "sum",
  big_mark = " ,",
  height = "25px"
)

## -----------------------------------------------------------------------------
kpiwidget(
  data = df_shared,
  column = "mpg",
  kpi = "mean",
  prefix = "mean mpg: ",
  height = "25px"
)

## -----------------------------------------------------------------------------
kpiwidget(
  data = df_shared,
  column = "mpg",
  kpi = "count",
  comparison = "share",
  group1 = ~ cyl == 4,
  suffix = " %",
  height = "25px"
)

