% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/konfound-glm-dichotomous.R
\name{konfound_glm_dichotomous}
\alias{konfound_glm_dichotomous}
\title{Konfound Analysis for Generalized Linear Models with Dichotomous Outcomes}
\usage{
konfound_glm_dichotomous(
  model_object,
  tested_variable_string,
  alpha,
  tails,
  to_return,
  n_treat,
  switch_trm,
  replace
)
}
\arguments{
\item{model_object}{The model object produced by glm.}

\item{tested_variable_string}{The name of the variable being tested.}

\item{alpha}{Significance level for hypothesis testing.}

\item{tails}{Number of tails for the test (1 or 2).}

\item{to_return}{The type of output to return.}

\item{n_treat}{Number of treatment cases.}

\item{switch_trm}{Term to switch for sensitivity analysis.}

\item{replace}{Boolean indicating whether to replace cases or not.}
}
\value{
The results of the konfound analysis.
}
\description{
This function performs konfound analysis on a generalized linear model
object with a dichotomous outcome. It uses 'broom' to tidy model outputs
and calculates the sensitivity of inferences.
}
