#' Getter/setter methods for koRpus objects
#' 
#' These methods should be used to get or set values of tagged text objects
#' generated by koRpus functions like \code{treetag()} or \code{tokenize()}.
#' 
#' \itemize{
#' 	\item{\code{taggedText()} }{returns the \code{TT.res} slot.}
#' 	\item{\code{describe()} }{returns the \code{desc} slot.}
#' 	\item{\code{language()} }{returns the \code{lang} slot.}
#' }
#' @rdname kRp.taggedText-methods
#' @docType methods
#' @include kRp.tagged-class.R
#' @exportMethod taggedText
#' @examples
#' \dontrun{
#' taggedText(tagged.txt)
#' }
setGeneric("taggedText", function(obj) standardGeneric("taggedText"))
#' @rdname kRp.taggedText-methods
#' @docType methods
#' @aliases
#'		taggedText,-methods
#'		taggedText,kRp.taggedText-method
setMethod("taggedText",
	signature=signature(obj="kRp.taggedText"),
	function (obj){
		result <- slot(obj, name="TT.res")
		return(result)
	}
)

#' @rdname kRp.taggedText-methods
#' @exportMethod taggedText<-
setGeneric("taggedText<-", function(obj, value) standardGeneric("taggedText<-"))
#' @rdname kRp.taggedText-methods
#' @docType methods
#' @aliases
#'		taggedText<-,-methods
#'		taggedText<-,kRp.taggedText-method
setMethod("taggedText<-",
	signature=signature(obj="kRp.taggedText"),
	function (obj, value){
		slot(obj, name="TT.res") <- value
		return(obj)
	}
)


#' @exportMethod describe
#' @rdname kRp.taggedText-methods
setGeneric("describe", function(obj) standardGeneric("describe"))
#' @rdname kRp.taggedText-methods
#' @docType methods
#' @aliases
#'		describe,-methods
#'		describe,kRp.taggedText-method
setMethod("describe",
	signature=signature(obj="kRp.taggedText"),
	function (obj){
		result <- slot(obj, name="desc")
		return(result)
	}
)

#' @rdname kRp.taggedText-methods
#' @exportMethod describe<-
setGeneric("describe<-", function(obj, value) standardGeneric("describe<-"))
#' @rdname kRp.taggedText-methods
#' @docType methods
#' @aliases
#'		describe<-,-methods
#'		describe<-,kRp.taggedText-method
setMethod("describe<-",
	signature=signature(obj="kRp.taggedText"),
	function (obj, value){
		slot(obj, name="desc") <- value
		return(obj)
	}
)


#' @exportMethod language
#' @rdname kRp.taggedText-methods
setGeneric("language", function(obj) standardGeneric("language"))
#' @rdname kRp.taggedText-methods
#' @docType methods
#' @aliases
#'		language,-methods
#'		language,kRp.taggedText-method
setMethod("language",
	signature=signature(obj="kRp.taggedText"),
	function (obj){
		result <- slot(obj, name="lang")
		return(result)
	}
)

#' @rdname kRp.taggedText-methods
#' @exportMethod language<-
setGeneric("language<-", function(obj, value) standardGeneric("language<-"))
#' @rdname kRp.taggedText-methods
#' @docType methods
#' @aliases
#'		language<-,-methods
#'		language<-,kRp.taggedText-method
setMethod("language<-",
	signature=signature(obj="kRp.taggedText"),
	function (obj, value){
		slot(obj, name="lang") <- value
		return(obj)
	}
)


#' @param obj An arbitrary \code{R} object.
#' @rdname kRp.taggedText-methods
#' @export
is.taggedText <- function(obj){
	inherits(obj, "kRp.taggedText")
}
