% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_forward_selection.R
\name{stat.forward_selection}
\alias{stat.forward_selection}
\title{Importance statistics based on forward selection}
\usage{
stat.forward_selection(X, X_k, y, omp = F)
}
\arguments{
\item{X}{n-by-p matrix of original variables.}

\item{X_k}{n-by-p matrix of knockoff variables.}

\item{y}{numeric vector of length n, containing the response variables.}

\item{omp}{whether to use orthogonal matching pursuit (default: F).}
}
\value{
A vector of statistics \eqn{W} of length p.
}
\description{
Computes the statistic
  \deqn{W_j = \max(Z_j, Z_{j+p}) \cdot \mathrm{sgn}(Z_j - Z_{j+p}),}
where \eqn{Z_1,\dots,Z_{2p}} give the reverse order in which the 2p
variables (the originals and the knockoffs) enter the forward selection 
model.
See the Details for information about forward selection.
}
\details{
In \emph{forward selection}, the variables are chosen iteratively to maximize
the inner product with the residual from the previous step. The initial
residual is always \code{y}. In standard forward selection
(\code{stat.forward_selection}), the next residual is the remainder after
regressing on the selected variable; when orthogonal matching pursuit
is used, the next residual is the remainder
after regressing on \emph{all} the previously selected variables.
}
\examples{
set.seed(2022)
p=100; n=100; k=15
mu = rep(0,p); Sigma = diag(p)
X = matrix(rnorm(n*p),n)
nonzero = sample(p, k)
beta = 3.5 * (1:p \%in\% nonzero)
y = X \%*\% beta + rnorm(n)
knockoffs = function(X) create.gaussian(X, mu, Sigma)

# Basic usage with default arguments
result = knockoff.filter(X, y, knockoffs=knockoffs,
                           statistic=stat.forward_selection)
print(result$selected)

# Advanced usage with custom arguments
foo = stat.forward_selection
k_stat = function(X, X_k, y) foo(X, X_k, y, omp=TRUE)
result = knockoff.filter(X, y, knockoffs=knockoffs, statistic=k_stat)
print(result$selected)

}
\seealso{
Other statistics: 
\code{\link{stat.glmnet_coefdiff}()},
\code{\link{stat.glmnet_lambdadiff}()},
\code{\link{stat.lasso_coefdiff_bin}()},
\code{\link{stat.lasso_coefdiff}()},
\code{\link{stat.lasso_lambdadiff_bin}()},
\code{\link{stat.lasso_lambdadiff}()},
\code{\link{stat.random_forest}()},
\code{\link{stat.sqrt_lasso}()},
\code{\link{stat.stability_selection}()}
}
\concept{statistics}
