% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{minmax}
\alias{minmax}
\title{Minmax normalization}
\usage{
minmax(X, rows = FALSE, values = NULL)
}
\arguments{
\item{X}{Numeric matrix or data.frame of any size.}

\item{rows}{If TRUE, the minmax normalization is done by row; otherwise, it
is done by column. (Defaults: FALSE)}

\item{values}{(optional) A list containing two elements, the "max"
values and the "min" values. If no value is passed, the typical minmax normalization
(which normalizes the dataset between 0 and 1) is computed with the observed
maximum and minimum value in each column (or row) of X.}
}
\value{
Minmax-normalized X.
}
\description{
Minmax normalization. Custom min/max values may be passed to the function.
}
\examples{
dat <- matrix(rnorm(100),ncol=10,nrow=10)
dat_minmax <- minmax(dat)
apply(dat_minmax,2,min) ## Min values = 0
apply(dat_minmax,2,max) ## Max values = 1
# We can also explicitly state the max and min values:
values <- list(min=apply(dat,2,min),max=apply(dat,2,max))
dat_minmax <- minmax(dat,values=values)
}
