% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_functions.R
\name{RBF}
\alias{RBF}
\title{Gaussian RBF (Radial Basis Function) kernel}
\usage{
RBF(X, g = NULL)
}
\arguments{
\item{X}{Matrix or data.frame that contains real numbers ("integer", "float" or "double").}

\item{g}{Gamma hyperparameter. If g=0 or NULL, `RBF()` returns the matrix of squared Euclidean
distances instead of the RBF kernel matrix.}
}
\value{
Kernel matrix (dimension: \emph{NxN}).
}
\description{
`RBF()` computes the RBF kernel between all possible pairs of rows of a
matrix or data.frame with dimension \emph{NxD}.
}
\details{
Let \eqn{x_i,x_j} be two real vectors. Then, the RBF kernel is defined as:
\deqn{K_{RBF}(x_i,x_j)=\exp(-\gamma \|x_i - x_j \|^2)}

Sometimes the RBF kernel is given a hyperparameter called sigma. In that case:
\eqn{\gamma = 1/\sigma^2}.
}
\examples{
dat <- matrix(rnorm(250),ncol=50,nrow=5)
RBF(dat,g=0.1)
}
