% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_measures.R
\name{Acc_rnd}
\alias{Acc_rnd}
\title{Accuracy of a random model}
\usage{
Acc_rnd(target, freq = FALSE)
}
\arguments{
\item{target}{A character vector or a factor. Alternatively, a numeric vector
(see below).}

\item{freq}{TRUE if `target` contains the frequencies of the classes (in this
case, `target` should be numeric), FALSE otherwise. (Defaults: FALSE).}
}
\value{
Expected accuracy of a random classification model (a single value).
}
\description{
`Acc_rnd()` computes the expected accuracy of a random classifier based on the
class frequencies of the target. This measure can be used as a benchmark when contrasted
to the accuracy (in test) of a given prediction model.
}
\examples{
# Expected accuracy of a random model:
target <- c(rep("a",5),rep("b",2))
Acc_rnd(target)
# This is the same than:
freqs <- c(5/7,2/7)
Acc_rnd(freqs,freq=TRUE)
}
