#returns a landscape with a sample of populations and or individuals within populations
landscape.sample <- function(rland,np=NULL,ns=NULL)
  {
    if (!is.null(np))
      {
        pops <- sample(unique(landscape.populations(rland)),
                       ifelse(length(unique(landscape.populations(rland)))>np,np,length(unique(landscape.populations(rland)))),
                      ,replace=F)
        rland$individuals <- rland$individuals[landscape.populations(rland) %in% pops,]
      }
    if (!is.null(ns))
      {
        pops <- landscape.populations(rland)
        ptbl <- table(pops)
        names <- as.numeric(names(which(ptbl>=np)))
        rland$individuals <- rland$individuals[
                                               as.numeric(unlist(sapply(unique(names),
                                                                        function(x,pops,ns)
                                                                        {
                                                                          ss <- ifelse(length(which(pops==x))>ns,
                                                                                       ns,length(which(pops==x)))
                                                                          sample(which(pops==x),ss,replace=F)
                                                                        },pops=pops,ns=ns)))
                                               ,]
      }
    rland
  }
