% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizers.R
\name{Optimizers}
\alias{Optimizers}
\alias{SGD}
\alias{RMSprop}
\alias{Adagrad}
\alias{Adadelta}
\alias{Adam}
\alias{Adamax}
\alias{Nadam}
\title{Optimizers}
\usage{
SGD(lr = 0.01, momentum = 0, decay = 0, nesterov = FALSE,
  clipnorm = -1, clipvalue = -1)

RMSprop(lr = 0.001, rho = 0.9, epsilon = 1e-08, decay = 0,
  clipnorm = -1, clipvalue = -1)

Adagrad(lr = 0.01, epsilon = 1e-08, decay = 0, clipnorm = -1,
  clipvalue = -1)

Adadelta(lr = 1, rho = 0.95, epsilon = 1e-08, decay = 0,
  clipnorm = -1, clipvalue = -1)

Adam(lr = 0.001, beta_1 = 0.9, beta_2 = 0.999, epsilon = 1e-08,
  decay = 0, clipnorm = -1, clipvalue = -1)

Adamax(lr = 0.002, beta_1 = 0.9, beta_2 = 0.999, epsilon = 1e-08,
  decay = 0, clipnorm = -1, clipvalue = -1)

Nadam(lr = 0.002, beta_1 = 0.9, beta_2 = 0.999, epsilon = 1e-08,
  schedule_decay = 0.004, clipnorm = -1, clipvalue = -1)
}
\arguments{
\item{lr}{float >= 0. Learning rate.}

\item{momentum}{float >= 0. Parameter updates momentum.}

\item{decay}{float >= 0. Learning rate decay over each update.}

\item{nesterov}{boolean. Whether to apply Nesterov momentum.}

\item{clipnorm}{float >= 0. Gradients will be clipped when their L2 norm
exceeds this value. Set to -1 to disable.}

\item{clipvalue}{float >= 0. Gradients will be clipped when their
absolute value exceeds this value. Set to -1 to disable.}

\item{rho}{float >= 0 to be used in \link{RMSprop}}

\item{epsilon}{float >= 0. Fuzz factor.}

\item{beta_1}{float, 0 < beta < 1. Generally close to 1.}

\item{beta_2}{float, 0 < beta < 1. Generally close to 1.}

\item{schedule_decay}{float >= 0. Learning rate decay over each
schedule in \link{Nadam}.}
}
\description{
Optimization functions to use in compiling a keras model.
}
\examples{
if(keras_available()) {
  X_train <- matrix(rnorm(100 * 10), nrow = 100)
  Y_train <- to_categorical(matrix(sample(0:2, 100, TRUE), ncol = 1), 3)
  
  mod <- Sequential()
  mod$add(Dense(units = 50, input_shape = dim(X_train)[2]))
  mod$add(Activation("relu"))
  mod$add(Dense(units = 3))
  mod$add(Activation("softmax"))
  
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = SGD())
  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
  
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = RMSprop())
  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
  
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = Adagrad())
  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
  
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = Adadelta())
  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
  
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = Adam())
  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
  
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = Adamax())
  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
  
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = Nadam())
  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
}

}
\references{
Chollet, Francois. 2015. \href{https://keras.io/}{Keras: Deep Learning library for Theano and TensorFlow}.
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
