% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applications.R
\name{application_mobilenet}
\alias{application_mobilenet}
\title{Instantiates the MobileNet architecture.}
\usage{
application_mobilenet(
  input_shape = NULL,
  alpha = 1,
  depth_multiplier = 1L,
  dropout = 0.001,
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  pooling = NULL,
  classes = 1000L,
  classifier_activation = "softmax",
  name = NULL
)
}
\arguments{
\item{input_shape}{Optional shape tuple, only to be specified if \code{include_top}
is \code{FALSE} (otherwise the input shape has to be \verb{(224, 224, 3)}
(with \code{"channels_last"} data format) or \verb{(3, 224, 224)}
(with \code{"channels_first"} data format).
It should have exactly 3 inputs channels, and width and
height should be no smaller than 32. E.g. \verb{(200, 200, 3)} would
be one valid value. Defaults to \code{NULL}.
\code{input_shape} will be ignored if the \code{input_tensor} is provided.}

\item{alpha}{Controls the width of the network. This is known as the width
multiplier in the MobileNet paper.
\itemize{
\item If \code{alpha < 1.0}, proportionally decreases the number
of filters in each layer.
\item If \code{alpha > 1.0}, proportionally increases the number
of filters in each layer.
\item If \code{alpha == 1}, default number of filters from the paper
are used at each layer. Defaults to \code{1.0}.
}}

\item{depth_multiplier}{Depth multiplier for depthwise convolution.
This is called the resolution multiplier in the MobileNet paper.
Defaults to \code{1.0}.}

\item{dropout}{Dropout rate. Defaults to \code{0.001}.}

\item{include_top}{Boolean, whether to include the fully-connected layer
at the top of the network. Defaults to \code{TRUE}.}

\item{weights}{One of \code{NULL} (random initialization), \code{"imagenet"}
(pre-training on ImageNet), or the path to the weights file
to be loaded. Defaults to \code{"imagenet"}.}

\item{input_tensor}{Optional Keras tensor (i.e. output of \code{keras_input()})
to use as image input for the model. \code{input_tensor} is useful
for sharing inputs between multiple different networks.
Defaults to \code{NULL}.}

\item{pooling}{Optional pooling mode for feature extraction when \code{include_top}
is \code{FALSE}.
\itemize{
\item \code{NULL} (default) means that the output of the model will be
the 4D tensor output of the last convolutional block.
\item \code{avg} means that global average pooling
will be applied to the output of the
last convolutional block, and thus
the output of the model will be a 2D tensor.
\item \code{max} means that global max pooling will be applied.
}}

\item{classes}{Optional number of classes to classify images into,
only to be specified if \code{include_top} is \code{TRUE}, and if
no \code{weights} argument is specified. Defaults to \code{1000}.}

\item{classifier_activation}{A \code{str} or callable. The activation function
to use on the "top" layer. Ignored unless \code{include_top=TRUE}.
Set \code{classifier_activation=NULL} to return the logits of the "top"
layer. When loading pretrained weights, \code{classifier_activation}
can only be \code{NULL} or \code{"softmax"}.}

\item{name}{The name of the model (string).}
}
\value{
A model instance.
}
\description{
Instantiates the MobileNet architecture.
}
\section{Reference}{
\itemize{
\item \href{https://arxiv.org/abs/1704.04861}{MobileNets: Efficient Convolutional Neural Networks for Mobile Vision Applications}
}

This function returns a Keras image classification model,
optionally loaded with weights pre-trained on ImageNet.

For image classification use cases, see
\href{https://keras.io/api/applications/#usage-examples-for-image-classification-models}{this page for detailed examples}.

For transfer learning use cases, make sure to read the
\href{https://keras.io/guides/transfer_learning/}{guide to transfer learning & fine-tuning}.
}

\section{Note}{
Each Keras Application expects a specific kind of input preprocessing.
For MobileNet, call \code{\link[=application_preprocess_inputs]{application_preprocess_inputs()}}
on your inputs before passing them to the model.
\code{\link[=application_preprocess_inputs]{application_preprocess_inputs()}} will scale input pixels between \code{-1} and \code{1}.
}

\seealso{
\itemize{
\item \url{https://keras.io/api/applications/mobilenet#mobilenet-function}
}
}
