% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_file}
\alias{get_file}
\title{Downloads a file from a URL if it not already in the cache.}
\usage{
get_file(
  fname = NULL,
  origin = NULL,
  ...,
  file_hash = NULL,
  cache_subdir = "datasets",
  hash_algorithm = "auto",
  extract = FALSE,
  archive_format = "auto",
  cache_dir = NULL,
  force_download = FALSE
)
}
\arguments{
\item{fname}{Name of the file. If an absolute path, e.g. \code{"/path/to/file.txt"}
is specified, the file will be saved at that location.
If \code{NULL}, the name of the file at \code{origin} will be used.}

\item{origin}{Original URL of the file.}

\item{...}{For forward/backward compatability.}

\item{file_hash}{The expected hash string of the file after download.
The sha256 and md5 hash algorithms are both supported.}

\item{cache_subdir}{Subdirectory under the Keras cache dir where the file is
saved. If an absolute path, e.g. \code{"/path/to/folder"} is
specified, the file will be saved at that location.}

\item{hash_algorithm}{Select the hash algorithm to verify the file.
options are \verb{"md5'}, \verb{"sha256'}, and \verb{"auto'}.
The default 'auto' detects the hash algorithm in use.}

\item{extract}{\code{TRUE} tries extracting the file as an Archive, like tar or zip.}

\item{archive_format}{Archive format to try for extracting the file.
Options are \verb{"auto'}, \verb{"tar'}, \verb{"zip'}, and \code{NULL}.
\code{"tar"} includes tar, tar.gz, and tar.bz files.
The default \code{"auto"} corresponds to \code{c("tar", "zip")}.
\code{NULL} or an empty list will return no matches found.}

\item{cache_dir}{Location to store cached files, when \code{NULL} it
defaults to \code{Sys.getenv("KERAS_HOME", "~/.keras/")}.}

\item{force_download}{If \code{TRUE}, the file will always be re-downloaded
regardless of the cache state.}
}
\value{
Path to the downloaded file.

** Warning on malicious downloads **

Downloading something from the Internet carries a risk.
NEVER download a file/archive if you do not trust the source.
We recommend that you specify the \code{file_hash} argument
(if the hash of the source file is known) to make sure that the file you
are getting is the one you expect.
}
\description{
By default the file at the url \code{origin} is downloaded to the
cache_dir \verb{~/.keras}, placed in the cache_subdir \code{datasets},
and given the filename \code{fname}. The final location of a file
\code{example.txt} would therefore be \verb{~/.keras/datasets/example.txt}.
Files in \code{.tar}, \code{.tar.gz}, \code{.tar.bz}, and \code{.zip} formats can
also be extracted.

Passing a hash will verify the file after download. The command line
programs \code{shasum} and \code{sha256sum} can compute the hash.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{path_to_downloaded_file <- get_file(
    origin = "https://storage.googleapis.com/download.tensorflow.org/example_images/flower_photos.tgz",
    extract = TRUE
)
}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/utils/python_utils#getfile-function}
}

Other utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{clear_session}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{get_source_inputs}()} \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{normalize}()} \cr
\code{\link{pad_sequences}()} \cr
\code{\link{set_random_seed}()} \cr
\code{\link{split_dataset}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
\code{\link{to_categorical}()} \cr
\code{\link{zip_lists}()} \cr
}
\concept{utils}
