% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/losses.R
\name{loss_log_cosh}
\alias{loss_log_cosh}
\title{Computes the logarithm of the hyperbolic cosine of the prediction error.}
\usage{
loss_log_cosh(
  y_true,
  y_pred,
  ...,
  reduction = "sum_over_batch_size",
  name = "log_cosh"
)
}
\arguments{
\item{y_true}{Ground truth values with shape = \verb{[batch_size, d0, .. dN]}.}

\item{y_pred}{The predicted values with shape = \verb{[batch_size, d0, .. dN]}.}

\item{...}{For forward/backward compatability.}

\item{reduction}{Type of reduction to apply to loss. Options are \code{"sum"},
\code{"sum_over_batch_size"} or \code{NULL}. Defaults to
\code{"sum_over_batch_size"}.}

\item{name}{Optional name for the instance.}
}
\value{
Logcosh error values with shape = \verb{[batch_size, d0, .. dN-1]}.
}
\description{
Formula:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{loss <- mean(log(cosh(y_pred - y_true)), axis=-1)
}\if{html}{\out{</div>}}

Note that \code{log(cosh(x))} is approximately equal to \code{(x ** 2) / 2} for small
\code{x} and to \code{abs(x) - log(2)} for large \code{x}. This means that 'logcosh' works
mostly like the mean squared error, but will not be so strongly affected by
the occasional wildly incorrect prediction.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{y_true <- rbind(c(0., 1.), c(0., 0.))
y_pred <- rbind(c(1., 1.), c(0., 0.))
loss <- loss_log_cosh(y_true, y_pred)
# 0.108
}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/losses/regression_losses#logcosh-class}
}

Other losses: \cr
\code{\link{Loss}()} \cr
\code{\link{loss_binary_crossentropy}()} \cr
\code{\link{loss_binary_focal_crossentropy}()} \cr
\code{\link{loss_categorical_crossentropy}()} \cr
\code{\link{loss_categorical_focal_crossentropy}()} \cr
\code{\link{loss_categorical_hinge}()} \cr
\code{\link{loss_cosine_similarity}()} \cr
\code{\link{loss_dice}()} \cr
\code{\link{loss_hinge}()} \cr
\code{\link{loss_huber}()} \cr
\code{\link{loss_kl_divergence}()} \cr
\code{\link{loss_mean_absolute_error}()} \cr
\code{\link{loss_mean_absolute_percentage_error}()} \cr
\code{\link{loss_mean_squared_error}()} \cr
\code{\link{loss_mean_squared_logarithmic_error}()} \cr
\code{\link{loss_poisson}()} \cr
\code{\link{loss_sparse_categorical_crossentropy}()} \cr
\code{\link{loss_squared_hinge}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_squared_hinge}()} \cr
}
\concept{losses}
