% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_f1_score}
\alias{metric_f1_score}
\title{Computes F-1 Score.}
\usage{
metric_f1_score(
  ...,
  average = NULL,
  threshold = NULL,
  name = "f1_score",
  dtype = NULL
)
}
\arguments{
\item{...}{For forward/backward compatability.}

\item{average}{Type of averaging to be performed on data.
Acceptable values are \code{NULL}, \code{"micro"}, \code{"macro"}
and \code{"weighted"}. Defaults to \code{NULL}.
If \code{NULL}, no averaging is performed and \code{result()} will return
the score for each class.
If \code{"micro"}, compute metrics globally by counting the total
true positives, false negatives and false positives.
If \code{"macro"}, compute metrics for each label,
and return their unweighted mean.
This does not take label imbalance into account.
If \code{"weighted"}, compute metrics for each label,
and return their average weighted by support
(the number of true instances for each label).
This alters \code{"macro"} to account for label imbalance.
It can result in an score that is not between precision and recall.}

\item{threshold}{Elements of \code{y_pred} greater than \code{threshold} are
converted to be 1, and the rest 0. If \code{threshold} is
\code{NULL}, the argmax of \code{y_pred} is converted to 1, and the rest to 0.}

\item{name}{Optional. String name of the metric instance.}

\item{dtype}{Optional. Data type of the metric result.}
}
\value{
a \code{Metric} instance is returned. The \code{Metric} instance can be passed
directly to \code{compile(metrics = )}, or used as a standalone object. See
\code{?Metric} for example usage.
}
\description{
Formula:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{f1_score <- 2 * (precision * recall) / (precision + recall)
}\if{html}{\out{</div>}}

This is the harmonic mean of precision and recall.
Its output range is \verb{[0, 1]}. It works for both multi-class
and multi-label classification.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{metric <- metric_f1_score(threshold = 0.5)
y_true <- rbind(c(1, 1, 1),
                c(1, 0, 0),
                c(1, 1, 0))
y_pred <- rbind(c(0.2, 0.6, 0.7),
                c(0.2, 0.6, 0.6),
                c(0.6, 0.8, 0.0))
metric$update_state(y_true, y_pred)
result <- metric$result()
result
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor([0.49999997 0.79999995 0.66666657], shape=(3), dtype=float32)

}\if{html}{\out{</div>}}
}

\section{Returns}{
F-1 Score: float.
}

\seealso{
Other f score metrics: \cr
\code{\link{metric_fbeta_score}()} \cr

Other metrics: \cr
\code{\link{Metric}()} \cr
\code{\link{custom_metric}()} \cr
\code{\link{metric_auc}()} \cr
\code{\link{metric_binary_accuracy}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_binary_iou}()} \cr
\code{\link{metric_categorical_accuracy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_cosine_similarity}()} \cr
\code{\link{metric_false_negatives}()} \cr
\code{\link{metric_false_positives}()} \cr
\code{\link{metric_fbeta_score}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_iou}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_log_cosh_error}()} \cr
\code{\link{metric_mean}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_iou}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_mean_wrapper}()} \cr
\code{\link{metric_one_hot_iou}()} \cr
\code{\link{metric_one_hot_mean_iou}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_precision}()} \cr
\code{\link{metric_precision_at_recall}()} \cr
\code{\link{metric_r2_score}()} \cr
\code{\link{metric_recall}()} \cr
\code{\link{metric_recall_at_precision}()} \cr
\code{\link{metric_root_mean_squared_error}()} \cr
\code{\link{metric_sensitivity_at_specificity}()} \cr
\code{\link{metric_sparse_categorical_accuracy}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_sparse_top_k_categorical_accuracy}()} \cr
\code{\link{metric_specificity_at_sensitivity}()} \cr
\code{\link{metric_squared_hinge}()} \cr
\code{\link{metric_sum}()} \cr
\code{\link{metric_top_k_categorical_accuracy}()} \cr
\code{\link{metric_true_negatives}()} \cr
\code{\link{metric_true_positives}()} \cr
}
\concept{f score metrics}
\concept{metrics}
