% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layer.R
\name{Layer}
\alias{Layer}
\title{Create a custom Layer}
\usage{
Layer(
  classname,
  initialize,
  build = NULL,
  call = NULL,
  compute_output_shape = NULL,
  ...,
  inherit = tensorflow::tf$keras$layers$Layer
)
}
\arguments{
\item{classname}{the name of the custom Layer.}

\item{initialize}{a function. This is where you define the arguments used to further
build your layer. For example, a dense layer would take the \code{units} argument.
You should always call \code{super()$`__init__()`} to initialize the base
inherited layer.}

\item{build}{a function that takes \code{input_shape} as argument. This is where you will
define your weights. Note that if your layer doesn’t define trainable weights then
you need not implement this method.}

\item{call}{This is where the layer’s logic lives. Unless you want your layer to
support masking, you only have to care about the first argument passed to \code{call}
(the input tensor).}

\item{compute_output_shape}{a function that takes \code{input_shape} as an argument. In
case your layer modifies the shape of its input, you should specify here the
shape transformation logic. This allows Keras to do automatic shape inference.
If you don’t modify the shape of the input then you need not implement this
method.}

\item{...}{Any other methods and/or attributes can be specified using named
arguments. They will be added to the layer class.}

\item{inherit}{the Keras layer to inherit from}
}
\value{
A function that wraps \code{create_layer}, similar to \code{keras::layer_dense}.
}
\description{
Create a custom Layer
}
\examples{
\dontrun{

layer_dense2 <- Layer(
  "Dense2",
  
  initialize = function(units) {
    super()$`__init__`()
    self$units <- as.integer(units)
  },
  
  build = function(input_shape) {
    print(class(input_shape))
    self$kernel <- self$add_weight(
      name = "kernel",
      shape = list(input_shape[[2]], self$units),
      initializer = "uniform",
      trainable = TRUE
    )
  },
  
  call = function(x) {
    tensorflow::tf$matmul(x, self$kernel)
  },
  
  compute_output_shape = function(input_shape) {
    list(input_shape[[1]], self$units)
  }
  
)

l <- layer_dense2(units = 10)
l(matrix(runif(10), ncol = 1))

}


}
