% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_rnn}
\alias{k_rnn}
\title{Iterates over the time dimension of a tensor}
\usage{
k_rnn(step_function, inputs, initial_states, go_backwards = FALSE,
  mask = NULL, constants = NULL, unroll = FALSE,
  input_length = NULL)
}
\arguments{
\item{step_function}{RNN step function.}

\item{inputs}{Tensor with shape (samples, ...) (no time dimension),
representing input for the batch of samples at a certain time step.}

\item{initial_states}{Tensor with shape (samples, output_dim) (no time
dimension), containing the initial values for the states used in the step
function.}

\item{go_backwards}{Logical If \code{TRUE}, do the iteration over the time
dimension in reverse order and return the reversed sequence.}

\item{mask}{Binary tensor with shape (samples, time, 1), with a zero for
every element that is masked.}

\item{constants}{A list of constant values passed at each step.}

\item{unroll}{Whether to unroll the RNN or to use a symbolic loop
(while_loop or scan depending on backend).}

\item{input_length}{Not relevant in the TensorFlow implementation. Must be
specified if using unrolling with Theano.}
}
\value{
A list with:
\itemize{
\item \code{last_output}: the latest output of the rnn, of shape (samples, ...)
\item \code{outputs}: tensor with shape (samples, time, ...) where each entry
\code{outputs[s, t]} is the output of the step function at time t for sample s.
\item \code{new_states}: list of tensors, latest states returned by the step
function, of shape (samples, ...).
}
}
\description{
Iterates over the time dimension of a tensor
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://keras.rstudio.com/articles/backend.html#backend-functions}.
}

