% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{constraint_minmaxnorm}
\alias{constraint_minmaxnorm}
\title{MinMaxNorm weight constraint}
\usage{
constraint_minmaxnorm(min_value = 0, max_value = 1, rate = 1, axis = 0)
}
\arguments{
\item{min_value}{The minimum norm for the incoming weights.}

\item{max_value}{The maximum norm for the incoming weights.}

\item{rate}{The rate for enforcing the constraint: weights will be rescaled to
yield (1 - rate) * norm + rate * norm.clip(low, high). Effectively, this
means that rate=1.0 stands for strict enforcement of the constraint, while
rate<1.0 means that weights will be rescaled at each step to slowly move
towards a value inside the desired interval.}

\item{axis}{The axis along which to calculate weight norms. For instance, in
a dense layer the weight matrix has shape \code{input_dim, output_dim},
set \code{axis} to \code{0} to constrain each weight vector of length \code{input_dim,}.
In a convolution 2D layer with \code{dim_ordering="tf"}, the weight tensor has
shape \code{rows, cols, input_depth, output_depth}, set \code{axis} to \code{c(0, 1, 2)}
to constrain the weights of each filter tensor of size \code{rows, cols, input_depth}.}
}
\description{
Constrains the weights incident to each hidden unit to have the norm between
a lower bound and an upper bound.
}
\seealso{
Other constraints: \code{\link{constraint_maxnorm}},
  \code{\link{constraint_nonneg}},
  \code{\link{constraint_unitnorm}}
}
