% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlh_reshape.R
\name{mlh_reshape}
\alias{mlh_reshape}
\title{mlh_reshape}
\usage{
mlh_reshape(object)
}
\arguments{
\item{object}{A matrix with predicted probabilities for several classes.
Each row must sum up to 1.}
}
\value{
Returns a vector of type factor of the same length as rows in object,
representing the class with the highest probability for each observation in
object.
}
\description{
Machine learning helper function to reshape a matrix of
predicted probabilities to classes.
}
\examples{
set.seed(123)
class_0 <- rbeta(100, 2, 4)
class_1 <- (1 - class_0) * 0.4
class_2 <- (1 - class_0) * 0.6
dataset <- cbind("0" = class_0, "1" = class_1, "2" = class_2)
mlh_reshape(dataset)
}
