\name{eBellPol}
\alias{eBellPol}
\title{
Exponential Bell polynomials
}
\description{The function generates a complete or a partial exponential Bell polynomial.}

\usage{
eBellPol(n = 1, m = 0)
}

\arguments{
  \item{n}{integer, the degree of the polynomial}
  \item{m}{integer, the fixed degree of each monomial in the polynomial}
}

\details{Faa di Bruno's formula gives the coefficients of the exponential formal power series composition 
\code{f[g()]} obtained from the composition of the exponential formal power series \code{f} with \code{g}. 
Complete exponential Bell polynomials in the variables \code{y[1],...,y[n]} are generated by setting 
\code{f[i]=1} and \code{g[i]=y[i]}, for each \code{i} from \code{1} to \code{n}. Partial exponential Bell 
polynomials are polynomials in the variables \code{y[1],...,y[n-m+1]} with fixed degree \code{m}
for each of the involved monomials. Partial exponential Bell polynomials are recovered from 
Faa di Bruno's formula by setting \code{g[i]=y[i]} for each \code{i} from \code{1} to \code{n} and 
\code{f[i]=1} if \code{i=m, f[i]=0} otherwise.
}

\value{
 \item{string}{the expression of the exponential Bell polynomial}
}

\references{

C.A. Charalambides (2002) Enumerative Combinatoris, Chapman & Haii/CRC. 

E. Di Nardo, G. Guarino, D. Senato (2008) An unifying framework for k-statistics, polykays and their generalizations. 
Bernoulli. 14(2), 440-468. (download from \url{https://arxiv.org/pdf/math/0607623.pdf}) 
 
E. Di Nardo, G. Guarino, D. Senato (2008) Symbolic computation of moments of sampling distributions. 
Comp. Stat. Data Analysis. 52(11), 4909-4922. (download from \url{https://arxiv.org/abs/0806.0129}) 

E. Di Nardo, G. Guarino, D. Senato (2011) A new algorithm for computing the multivariate Faa di Bruno's formula. 
Appl. Math. Comp. 217, 6286--6295. (download from \url{https://arxiv.org/abs/1012.6008})

}

\author{
Elvira Di Nardo \email{elvira.dinardo@unito.it},\cr 
Giuseppe Guarino \email{giuseppe.guarino@rete.basilicata.it}
}

\section{Warning}{The value of the first parameter is the same as the \code{\link{MFB}} function in 
the univariate with univariate composition.}

\note{This function calls the \code{\link{MFB}} function in the \code{kStatistics} package.}


\seealso{
\code{\link{MFB}}
}


\examples{

# Return the complete exponential Bell Polynomial for n=5, that is 
# (y1^5) + 10(y1^3)(y2) + 15(y1)(y2^2) + 10(y1^2)(y3) + 10(y2)(y3) + 5(y1)(y4) + (y5)
eBellPol(5) 
# OR (same output)
eBellPol(5,0)

# Return the partial exponential Bell Polynomial for n=5 and m=3, that is 
# 15(y1)(y2^2) + 10(y1^2)(y3)
eBellPol(5,3)

}

% R KEYWORDS
\keyword{ univar }
\keyword{ list }
\keyword{ symbolmath }
\keyword{ combinatorics }