% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_justifications.R
\name{parse_justifications}
\alias{parse_justifications}
\alias{print.justifierDecisionGraph}
\alias{plot.justifierDecisionGraph}
\title{Parsing justifications}
\usage{
parse_justifications(
  x,
  justifierFields = "^date$|^framework$",
  fromFile = NULL,
  path = NULL,
  storeDecisionGraphSvg = FALSE,
  silent = TRUE
)

\method{print}{justifierDecisionGraph}(x, ...)

\method{plot}{justifierDecisionGraph}(x, ...)
}
\arguments{
\item{x}{An object resulting from a call to \code{\link[yum:load_and_simplify]{yum::load_and_simplify()}}.}

\item{justifierFields}{Which fields to copy from \code{justifier} metadata to
the elements within the specified scope.}

\item{fromFile}{The file from which the \code{justifier} specifications were read.}

\item{path}{The path holding these \code{justifier} specifications (not necessary
if \code{fromFile} is provided).}

\item{storeDecisionGraphSvg}{Whether to also produce (and return) the SVG
for the decision graph.}

\item{silent}{Whether to be chatty or quiet.}

\item{...}{Additional arguments are passed on to \code{\link[graphics:plot.default]{graphics::plot()}} for the
\code{print} method or to \code{\link[DiagrammeR:render_graph]{DiagrammeR::render_graph()}} for the \code{plot} method.}
}
\value{
The parsed \code{justifier} object.
}
\description{
This function is normally called by \code{\link[=load_justifications]{load_justifications()}}; however,
sometimes it may be desirable to parse justifications embedded in more
complex objects, for example as provided by \code{\link[yum:load_and_simplify]{yum::load_and_simplify()}}.
Therefore, this function can also be called directly.
}
\details{
While there is some flexibility in how justifications can be specified,
they are most easily processed further if they all follow the same
conventions. This function ensures this. The convention is as follows:
\itemize{
\item all specifications are provided in four 'flat' lists, named after the
types of elements they contain;
\item all elements have  a unique identifier
\item all references to other elements are indeed only references to the other
elements' id's in these 'flat lists'
}
}
\examples{
### Specify an example text
exampleFile <-
  system.file("extdata",
              "simple-example.jmd",
              package="justifier");

### Show contents
cat(readLines(exampleFile), sep="\n");

### Load it with yum::load_and_simplify()
loadedMinutes <- yum::load_and_simplify(exampleFile);

### Show contents
names(loadedMinutes);

### Parse 'manually'
parsedJustifications <- justifier::parse_justifications(loadedMinutes);

### Show contents
names(parsedJustifications);

}
