% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestglm.R
\name{TableSubgroupGLM}
\alias{TableSubgroupGLM}
\title{TableSubgroupGLM: Sub-group analysis table for GLM.}
\usage{
TableSubgroupGLM(
  formula,
  var_subgroup = NULL,
  var_cov = NULL,
  data,
  family = "binomial",
  decimal.estimate = 2,
  decimal.percent = 1,
  decimal.pvalue = 3,
  labeldata = NULL
)
}
\arguments{
\item{formula}{formula with survival analysis.}

\item{var_subgroup}{1 sub-group variable for analysis, Default: NULL}

\item{var_cov}{Variables for additional adjust, Default: NULL}

\item{data}{Data or svydesign in survey package.}

\item{family}{family, "gaussian" or "binomial" or 'poisson' or 'quasipoisson'}

\item{decimal.estimate}{Decimal for estimate, Default: 2}

\item{decimal.percent}{Decimal for percent, Default: 1}

\item{decimal.pvalue}{Decimal for pvalue, Default: 3}

\item{labeldata}{Label info, made by `mk.lev` function, Default: NULL}
}
\value{
Sub-group analysis table.
}
\description{
Sub-group analysis table for GLM.
}
\details{
This result is used to make forestplot.
}
\examples{
library(survival)
library(dplyr)
lung \%>\%
  mutate(
    status = as.integer(status == 1),
    sex = factor(sex),
    kk = factor(as.integer(pat.karno >= 70))
  ) -> lung
TableSubgroupGLM(status ~ sex, data = lung, family = "binomial")
TableSubgroupGLM(status ~ sex, var_subgroup = "kk", data = lung, family = "binomial")

## survey design
library(survey)
data.design <- svydesign(id = ~1, data = lung)
TableSubgroupGLM(status ~ sex, data = data.design, family = "binomial")
TableSubgroupGLM(status ~ sex, var_subgroup = "kk", data = data.design, family = "binomial")
}
\seealso{
\code{\link[purrr]{safely}},\code{\link[purrr]{map}},\code{\link[purrr]{map2}}
 \code{\link[stats]{glm}}
 \code{\link[survey]{svyglm}}
}
